/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.ClassMetric;

public class NOA
extends ClassMetric {
    private boolean countPublic;
    private boolean countProtected;
    private boolean countPackage;
    private boolean countPrivate;
    private boolean countInherited;
    private boolean countConstants;

    protected void measure(AstType type, MetricResult result) {
        result.setValue(NOA.countAttributes(type, this.countPublic, this.countProtected, this.countPackage, this.countPrivate, this.countInherited, this.countConstants));
    }

    public static int countAttributes(AstType type, boolean countPublic, boolean countProtected, boolean countPackage, boolean countPrivate, boolean countInherited, boolean countConstants) {
        int result = 0;
        AstField[] fields = countInherited ? type.getAllFields() : type.getFields();
        int i = 0;
        while (i < fields.length) {
            AstField f = fields[i];
            if ((f.isPublic() && countPublic || f.isProtected() && countProtected || f.isPackage() && countPackage || f.isPrivate() && countPrivate) && (countConstants || !f.isFinal() || !f.isStatic())) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public void setDescriptor(IAnalyzerDescriptor descriptor) {
        super.setDescriptor(descriptor);
        this.countPublic = descriptor.getParameterRegistry().getBooleanValue("Count public", true);
        this.countProtected = descriptor.getParameterRegistry().getBooleanValue("Count protected", true);
        this.countPackage = descriptor.getParameterRegistry().getBooleanValue("Count package", true);
        this.countPrivate = descriptor.getParameterRegistry().getBooleanValue("Count private", true);
        this.countInherited = descriptor.getParameterRegistry().getBooleanValue("Count ancestors", false);
        this.countConstants = descriptor.getParameterRegistry().getBooleanValue("Count constants", false);
    }
}

