/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstModifiers;
import com.togethersoft.sca.ast.AstReturnStatement;
import com.togethersoft.sca.ast.AstSimpleReference;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.ClassMetric;

public class NAM
extends ClassMetric
implements AstModifiers {
    protected void measure(AstType type, MetricResult result) {
        int count = 0;
        AstMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (this.testMethod(methods[i])) {
                ++count;
            }
            ++i;
        }
        result.setValue(count);
    }

    private boolean testMethod(AstMethod method) {
        return method.isPublic() && NAM.isAccessorMethod(method) != null;
    }

    public static AstVariable isAccessorMethod(AstMethod method) {
        if (method == null) {
            return null;
        }
        AstCompoundStatement body = method.getBody();
        if (body == null) {
            return null;
        }
        AstStatement[] stmts = body.getStatements();
        if (stmts.length != 1) {
            return null;
        }
        if (stmts[0].getObjectKind() != 14) {
            return null;
        }
        AstExpression expr = ((AstReturnStatement)stmts[0]).getReturnExpression();
        if (expr == null || expr.getObjectKind() != 40) {
            return null;
        }
        AstDeclaration decl = ((AstSimpleReference)expr).getReferencedElement();
        if (decl != null && decl.getObjectKind() == 9 && decl.getDeclaringType() == method.getDeclaringType() && !decl.isStatic()) {
            return (AstVariable)decl;
        }
        return null;
    }
}

