/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstMember;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.internal.plugin.metric.impl.ClassMetric;

public abstract class MemberMetric
extends ClassMetric {
    protected boolean countPublic;
    protected boolean countProtected;
    protected boolean countPackage;
    protected boolean countPrivate;

    public void setDescriptor(IAnalyzerDescriptor descriptor) {
        super.setDescriptor(descriptor);
        this.countPublic = descriptor.getParameterRegistry().getBooleanValue("Count public", true);
        this.countProtected = descriptor.getParameterRegistry().getBooleanValue("Count protected", true);
        this.countPackage = descriptor.getParameterRegistry().getBooleanValue("Count package", true);
        this.countPrivate = descriptor.getParameterRegistry().getBooleanValue("Count private", true);
    }

    protected boolean isEligible(AstMember member) {
        if (member.isPublic() && this.countPublic) {
            return true;
        }
        if (member.isProtected() && this.countProtected) {
            return true;
        }
        if (member.isPrivate() && this.countPrivate) {
            return true;
        }
        return this.countPackage;
    }
}

