/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstCatchClause;
import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstDoStatement;
import com.togethersoft.sca.ast.AstForStatement;
import com.togethersoft.sca.ast.AstIfStatement;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.AstSwitchGroup;
import com.togethersoft.sca.ast.AstSwitchStatement;
import com.togethersoft.sca.ast.AstSynchronizedStatement;
import com.togethersoft.sca.ast.AstTryStatement;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstWhileStatement;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.ClassMetric;

public class MNOL
extends ClassMetric {
    private int currLevel;
    private int maxLevel;
    private boolean countCases;

    protected void measure(AstType subject, MetricResult result) {
        this.maxLevel = 0;
        AstMethod[] methods = subject.getMethods();
        int i = 0;
        while (i < methods.length) {
            this.currLevel = 0;
            this.processStatement((AstStatement)methods[i].getBody());
            ++i;
        }
        result.setValue(this.maxLevel);
    }

    public void setDescriptor(IAnalyzerDescriptor descriptor) {
        super.setDescriptor(descriptor);
        this.countCases = descriptor.getParameterRegistry().getBooleanValue("Case as branch", false);
    }

    private void processStatements(AstStatement[] stmts) {
        int i = 0;
        while (i < stmts.length) {
            this.processStatement(stmts[i]);
            ++i;
        }
    }

    private void processStatement(AstStatement stmt) {
        if (stmt == null) {
            return;
        }
        switch (stmt.getObjectKind()) {
            case 16: {
                ++this.currLevel;
                if (this.currLevel > this.maxLevel) {
                    this.maxLevel = this.currLevel;
                }
                AstIfStatement s = (AstIfStatement)stmt;
                this.processStatement(s.getThenStatement());
                this.processStatement(s.getElseStatement());
                --this.currLevel;
                break;
            }
            case 27: {
                ++this.currLevel;
                if (this.currLevel > this.maxLevel) {
                    this.maxLevel = this.currLevel;
                }
                AstDoStatement s = (AstDoStatement)stmt;
                this.processStatement(s.getBody());
                --this.currLevel;
                break;
            }
            case 10: {
                ++this.currLevel;
                if (this.currLevel > this.maxLevel) {
                    this.maxLevel = this.currLevel;
                }
                AstWhileStatement s = (AstWhileStatement)stmt;
                this.processStatement(s.getBody());
                --this.currLevel;
                break;
            }
            case 17: {
                ++this.currLevel;
                if (this.currLevel > this.maxLevel) {
                    this.maxLevel = this.currLevel;
                }
                AstForStatement s = (AstForStatement)stmt;
                this.processStatement(s.getBody());
                --this.currLevel;
                break;
            }
            case 13: {
                if (this.countCases) {
                    ++this.currLevel;
                    if (this.currLevel > this.maxLevel) {
                        this.maxLevel = this.currLevel;
                    }
                }
                AstSwitchStatement s = (AstSwitchStatement)stmt;
                AstSwitchGroup[] groups = s.getBody();
                int i = 0;
                while (i < groups.length) {
                    this.processStatements(groups[i].getStatements());
                    ++i;
                }
                if (!this.countCases) break;
                --this.currLevel;
                break;
            }
            case 11: {
                AstTryStatement s = (AstTryStatement)stmt;
                this.processStatement((AstStatement)s.getBody());
                if (s.getFinallyClause() != null) {
                    this.processStatement((AstStatement)s.getFinallyClause().getBody());
                }
                AstCatchClause[] handlers = s.getCatchClauses();
                int i = 0;
                while (i < handlers.length) {
                    this.processStatement((AstStatement)handlers[i].getBody());
                    ++i;
                }
                break;
            }
            case 12: {
                AstSynchronizedStatement s = (AstSynchronizedStatement)stmt;
                this.processStatement((AstStatement)s.getBody());
                break;
            }
            case 21: {
                AstCompoundStatement s = (AstCompoundStatement)stmt;
                this.processStatements(s.getStatements());
                break;
            }
        }
    }
}

