/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstIfStatement;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstSwitchStatement;
import com.togethersoft.sca.ast.visitor.AstStatementVisitor;
import com.togethersoft.sca.ast.visitor.AstStatementVisitorAdapter;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.MethodMetric;

public class MNOB
extends MethodMetric {
    protected void measure(AstMethod method, MetricResult result) {
        BranchCounter counter = new BranchCounter();
        AstCompoundStatement body = method.getBody();
        if (body != null) {
            body.visitStatements((AstStatementVisitor)counter);
        }
        result.setValue(counter.numBranches());
    }

    private static class BranchCounter
    extends AstStatementVisitorAdapter {
        private int nBranches;

        private BranchCounter() {
        }

        int numBranches() {
            return this.nBranches;
        }

        public void visitIfStatement(AstIfStatement stmt) {
            this.nBranches += stmt.getElseStatement() != null ? 2 : 1;
        }

        public void visitSwitchStatement(AstSwitchStatement stmt) {
            this.nBranches += stmt.getBody().length;
        }
    }
}

