/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstModel;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.ClassVisitor;

public class MIF
extends ClassVisitor {
    private int total;
    private int inherited;

    protected void measure(AstModel model, MetricResult result) {
        this.total = 0;
        this.inherited = 0;
        super.measure(model, result);
        if (this.total > 0) {
            result.setValue(this.inherited, this.total);
        } else {
            result.setValue(0);
        }
    }

    protected void measureType(AstType type) {
        super.measureType(type);
        AstMethod[] all = type.getAllMethods();
        AstMethod[] declared = type.getMethods();
        int numAll = all.length;
        int numDeclared = declared.length;
        if (type.isInterface()) {
            numAll = numDeclared;
        } else {
            int i = 0;
            while (i < all.length) {
                if (all[i].getDeclaringType().isInterface()) {
                    --numAll;
                }
                ++i;
            }
        }
        this.total += numAll;
        this.inherited += numAll - numDeclared;
    }
}

