/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstModel;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.core.plugin.metric.IMetricSurvey;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.ClassMetric;
import com.togethersoft.sca.internal.plugin.metric.impl.TableOfUsedMembers;
import java.util.HashSet;
import java.util.Iterator;

public class MIC
extends ClassMetric {
    private int numClasses;

    public IMetricSurvey survey(AstModel model) {
        this.numClasses = 0;
        AstPackage[] packages = model.getPackages();
        int i = 0;
        while (i < packages.length) {
            this.numClasses += this.countClasses(packages[i]);
            ++i;
        }
        return super.survey(model);
    }

    private int countClasses(AstPackage pkg) {
        int n = 0;
        AstPackage[] packages = pkg.getSubpackages();
        int i = 0;
        while (i < packages.length) {
            n += this.countClasses(packages[i]);
            ++i;
        }
        AstCompilationUnit[] files = pkg.getCompilationUnits();
        int i2 = 0;
        while (i2 < files.length) {
            n += files[i2].getTypes().length;
            ++i2;
        }
        return n;
    }

    protected void measure(AstType type, MetricResult result) {
        HashSet<AstType> set = new HashSet<AstType>();
        set.add(ClassMetric.getTopLevelType((AstObject)type));
        AstMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            this.addType(set, TableOfUsedMembers.getMethodReferences((AstDeclaration)methods[i]));
            ++i;
        }
        AstField[] vars = type.getFields();
        int i2 = 0;
        while (i2 < vars.length) {
            this.addType(set, TableOfUsedMembers.getMethodReferences((AstDeclaration)vars[i2]));
            ++i2;
        }
        result.setValue(set.size() - 1, this.numClasses);
    }

    private void addType(HashSet set, HashSet declSet) {
        Iterator it = declSet.iterator();
        while (it.hasNext()) {
            AstMethod method = (AstMethod)it.next();
            AstType type = ClassMetric.getTopLevelType((AstObject)method.getDeclaringType());
            if (type.getCompilationUnit() == null) continue;
            set.add(type);
        }
    }
}

