/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.visitor.AstExpressionVisitor;
import com.togethersoft.sca.ast.visitor.AstExpressionVisitorAdapter;

public class LOCMeasurer
extends AstExpressionVisitorAdapter {
    private int minLine;
    private boolean[] lines;

    public LOCMeasurer(int minLine, int maxLine) {
        this.minLine = minLine;
        this.lines = new boolean[maxLine - minLine + 1];
        this.lines[0] = true;
        this.lines[this.lines.length - 1] = true;
    }

    public int measure(AstStatement stmt) {
        int numLines = 0;
        if (stmt != null) {
            stmt.visitExpressions((AstExpressionVisitor)this);
        }
        int i = 0;
        while (i < this.lines.length) {
            if (this.lines[i]) {
                ++numLines;
            }
            ++i;
        }
        return numLines;
    }

    public void visitExpression(AstExpression expr) {
        this.lines[expr.getPosition().getStartLine() - this.minLine] = true;
        this.lines[expr.getPosition().getEndLine() - this.minLine] = true;
    }
}

