/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.core.IParameterBoolean;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.CMMetric;
import com.togethersoft.sca.internal.plugin.metric.impl.LOCMeasurer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class LOC
extends CMMetric {
    private LOCMeasurer measurer;

    protected boolean measure(AstType type, ArrayList methodResults, MetricResult result) {
        int numLines = 0;
        IParameterBoolean effectiveLines = (IParameterBoolean)this.getDescriptor().getParameterRegistry().getParameter("CountEffectiveLines", 1);
        if (effectiveLines.getValue()) {
            numLines += this.countClassLines(type);
            Object method = null;
            Iterator i = ((AbstractList)methodResults).iterator();
            while (i.hasNext()) {
                numLines += ((MetricResult)i.next()).getValue();
            }
        } else {
            numLines = type.getPosition().getEndLine() - type.getPosition().getStartLine() + 1;
        }
        result.setValue(numLines);
        return false;
    }

    protected void measure(AstMethod method, MetricResult result) {
        int lines = 0;
        IParameterBoolean effectiveLines = (IParameterBoolean)this.getDescriptor().getParameterRegistry().getParameter("CountEffectiveLines", 1);
        AstCompoundStatement body = method.getBody();
        if (body != null) {
            if (effectiveLines.getValue()) {
                this.measurer = new LOCMeasurer(method.getPosition().getStartLine(), method.getPosition().getEndLine());
                lines = this.measurer.measure((AstStatement)body);
            } else {
                AstStatement[] stmts = body.getStatements();
                if (stmts.length > 0) {
                    lines = stmts[stmts.length - 1].getPosition().getEndLine() - stmts[0].getPosition().getStartLine() + 1;
                }
            }
        }
        result.setValue(lines);
    }

    private int countClassLines(AstType type) {
        int numLines = 0;
        int minLine = type.getPosition().getStartLine();
        int maxLine = type.getPosition().getEndLine();
        boolean[] lines = new boolean[maxLine - minLine + 1];
        lines[0] = true;
        lines[lines.length - 1] = true;
        AstField[] fields = type.getFields();
        int i = 0;
        while (i < fields.length) {
            lines[fields[i].getPosition().getEndLine() - minLine] = true;
            lines[fields[i].getPosition().getStartLine() - minLine] = true;
            ++i;
        }
        int i2 = 0;
        while (i2 < lines.length) {
            if (lines[i2]) {
                ++numLines;
            }
            ++i2;
        }
        return numLines;
    }
}

