/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.ClassMetric;
import com.togethersoft.sca.internal.plugin.metric.impl.TableOfUsedMembers;

public class LCOM2
extends ClassMetric {
    protected void measure(AstType type, MetricResult result) {
        AstMethod[] methods = type.getExecutableFragments();
        AstField[] fields = type.getFields();
        if (fields.length == 0) {
            return;
        }
        long total = 0L;
        int numMethods = 0;
        int i = 0;
        while (i < methods.length) {
            if (!methods[i].isInitializer()) {
                ++numMethods;
                int j = 0;
                while (j < fields.length) {
                    if (!this.isFieldUsed(fields[j], methods[i])) {
                        ++total;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (numMethods > 0) {
            result.setValue((int)(100.0 * (double)total / (double)(fields.length * numMethods) + 0.5));
        }
    }

    private boolean isFieldUsed(AstField field, AstMethod method) {
        if (TableOfUsedMembers.getSimpleReferences((AstDeclaration)method).contains(field)) {
            return true;
        }
        return TableOfUsedMembers.getFieldReferences((AstDeclaration)method).contains(field);
    }
}

