/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.ClassMetric;
import com.togethersoft.sca.internal.plugin.metric.impl.TableOfUsedMembers;
import java.util.HashSet;
import java.util.Iterator;

public class LCOM1
extends ClassMetric {
    protected void measure(AstType type, MetricResult result) {
        int P = 0;
        int Q = 0;
        int numMethods = 0;
        if (type.getFields().length < 1) {
            return;
        }
        AstMethod[] methods = type.getExecutableFragments();
        int i = 0;
        while (i < methods.length - 1) {
            if (!methods[i].isInitializer()) {
                ++numMethods;
                int j = i + 1;
                while (j < methods.length) {
                    if (!methods[j].isInitializer()) {
                        HashSet set2;
                        HashSet set1 = this.computeResult(methods[i]);
                        if (LCOM1.hasCommonAccess(type, set1, set2 = this.computeResult(methods[j]))) {
                            ++Q;
                        } else {
                            ++P;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (numMethods < 2) {
            return;
        }
        int res = P > Q ? P - Q : 0;
        result.setValue(res);
    }

    private HashSet computeResult(AstMethod method) {
        HashSet set = TableOfUsedMembers.getFieldReferences((AstDeclaration)method);
        set.addAll(TableOfUsedMembers.getSimpleReferences((AstDeclaration)method));
        return set;
    }

    public static boolean hasCommonAccess(AstType type, HashSet set1, HashSet set2) {
        Iterator i = set1.iterator();
        while (i.hasNext()) {
            AstObject element = (AstObject)i.next();
            if (element == null || element.getDeclaringType() != type || !set2.contains(element)) continue;
            return true;
        }
        return false;
    }
}

