/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstReference;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.ClassMetric;

public class IUR
extends ClassMetric {
    protected void measure(AstType type, MetricResult result) {
        int numAllUsedMembers = 0;
        AstType ancestorType = type.getSuperClass();
        if (ancestorType == null) {
            result.setValue(0, 1);
        } else {
            int numUsedMembers = this.getUIR(type, ancestorType);
            AstField[] vars = ancestorType.getFields();
            AstMethod[] methods = ancestorType.getMethods();
            int j = 0;
            while (j < vars.length) {
                if (vars[j].isProtected()) {
                    ++numAllUsedMembers;
                }
                ++j;
            }
            int j2 = 0;
            while (j2 < methods.length) {
                if (methods[j2].isAbstract() || methods[j2].isProtected()) {
                    ++numAllUsedMembers;
                }
                ++j2;
            }
            result.setValue(numUsedMembers, numAllUsedMembers);
        }
    }

    protected int getUIR(AstType derivedType, AstType type) {
        int numUsedMembers = 0;
        AstField[] vars = type.getFields();
        AstMethod[] methods = type.getMethods();
        int j = 0;
        while (j < vars.length) {
            if (vars[j].isProtected()) {
                AstReference[] refs = vars[j].getReferences();
                int k = 0;
                while (k < refs.length) {
                    AstReference obj = refs[k];
                    if (obj.getDeclaringType() == derivedType) {
                        ++numUsedMembers;
                        break;
                    }
                    ++k;
                }
            }
            ++j;
        }
        int j2 = 0;
        while (j2 < methods.length) {
            if (methods[j2].isAbstract()) {
                AstMethod[] overMethods = methods[j2].overriddenBy();
                int k = 0;
                while (k < overMethods.length) {
                    if (overMethods[k].getDeclaringType() == derivedType) {
                        ++numUsedMembers;
                        break;
                    }
                    ++k;
                }
            } else if (methods[j2].isProtected()) {
                AstReference[] refs = methods[j2].getReferences();
                int n = 0;
                while (n < refs.length) {
                    if (refs[n].getDeclaringType() == derivedType) {
                        ++numUsedMembers;
                        break;
                    }
                    ++n;
                }
            }
            ++j2;
        }
        return numUsedMembers;
    }
}

