/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.ClassMetric;
import java.util.HashSet;

public class FO
extends ClassMetric {
    protected void measure(AstType type, MetricResult result) {
        HashSet set = new HashSet();
        AstField[] fields = type.getFields();
        set = this.proccessDecl((AstVariable[])fields, type, set);
        AstMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            AstType refType;
            AstTypeReference[] exps = methods[i].getExceptionTypes();
            int j = 0;
            while (j < exps.length) {
                refType = exps[j].getBaseType();
                set = this.addType(refType, type, set);
                ++j;
            }
            AstCompoundStatement body = methods[i].getBody();
            if (body != null) {
                set = this.proccessCompoundStmt(body, type, set);
            } else {
                AstVariable[] locals = methods[i].getParameters();
                set = this.proccessDecl(locals, type, set);
            }
            AstTypeReference ret = methods[i].getReturnType();
            refType = ret.getBaseType();
            set = this.addType(refType, type, set);
            ++i;
        }
        result.setValue(set.size());
    }

    private HashSet proccessCompoundStmt(AstCompoundStatement body, AstType type, HashSet set) {
        AstVariable[] locals = body.getLocalVariables();
        set = this.proccessDecl(locals, type, set);
        AstStatement[] stms = body.getStatements();
        int k = 0;
        while (k < stms.length) {
            if (stms[k].getObjectKind() == 21) {
                set = this.proccessCompoundStmt((AstCompoundStatement)stms[k], type, set);
            }
            ++k;
        }
        return set;
    }

    private HashSet proccessDecl(AstVariable[] decls, AstType type, HashSet set) {
        int i = 0;
        while (i < decls.length) {
            AstTypeReference ref = decls[i].getType();
            AstType refType = ref.getBaseType();
            set = this.addType(refType, type, set);
            ++i;
        }
        return set;
    }

    private HashSet addType(AstType refType, AstType type, HashSet set) {
        if (refType != null && !type.isDerivedFrom(refType) && !refType.getPackage().getQualifiedName().equals("java/lang")) {
            set.add(refType);
        }
        return set;
    }
}

