/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstComment;
import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.visitor.AstStatementVisitor;
import com.togethersoft.sca.ast.visitor.AstStatementVisitorAdapter;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.ClassMetric;

public class CR
extends ClassMetric {
    private boolean countJavadoc;
    private boolean countImpl;
    private int lastLine;
    protected int headerComment;
    protected int bodyComment;
    protected int bodyTotal;

    protected void measure(AstType type, MetricResult result) {
        AstCompilationUnit file = type.getCompilationUnit();
        if (file == null) {
            return;
        }
        boolean isFirst = file.getTypes()[0] == type;
        this.headerComment = this.countLines(type.getComments());
        if (isFirst) {
            this.headerComment += this.countLines(file.getComments());
        }
        this.bodyComment = 0;
        AstField[] fields = type.getFields();
        int i = 0;
        while (i < fields.length) {
            this.bodyComment += this.countLines(fields[i].getComments());
            ++i;
        }
        AstMethod[] methods = type.getExecutableFragments();
        int i2 = 0;
        while (i2 < methods.length) {
            this.bodyComment += this.countLines(methods[i2].getComments());
            ++i2;
        }
        CommentCounter counter = new CommentCounter();
        type.visitStatements((AstStatementVisitor)counter);
        this.bodyComment += counter.commentLines;
        this.bodyTotal = isFirst ? type.getPosition().getEndLine() : type.getPosition().getEndLine() - type.getPosition().getStartLine() + 1 + this.headerComment;
        result.setValue(this.headerComment + this.bodyComment, this.bodyTotal);
    }

    private int countLines(AstComment[] comments) {
        int total = 0;
        int i = 0;
        while (i < comments.length) {
            int start = comments[i].getPosition().getStartLine();
            int end = comments[i].getPosition().getEndLine();
            total += end - start + 1;
            if (start == this.lastLine) {
                --total;
            }
            this.lastLine = end;
            ++i;
        }
        return total;
    }

    public void setDescriptor(IAnalyzerDescriptor descriptor) {
        super.setDescriptor(descriptor);
        this.countJavadoc = descriptor.getParameterRegistry().getBooleanValue("Count documentation comments", true);
        this.countImpl = descriptor.getParameterRegistry().getBooleanValue("Count implementation comments", true);
    }

    private class CommentCounter
    extends AstStatementVisitorAdapter {
        int commentLines;

        private CommentCounter() {
        }

        public void visitStatement(AstStatement stmt) {
            this.commentLines += CR.this.countLines(stmt.getComments());
        }
    }
}

