/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstMember;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.core.IParameterStringEnum;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.MethodMetric;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class CMMetric
extends MethodMetric {
    private static final int UNKNOWN_TYPE = -1;
    private static final int CLASS_ONLY = 0;
    private static final int METHOD_ONLY = 1;
    private static final int CLASS_AND_METHOD = 2;
    private int kind = -1;

    protected void survey(MetricResult survey, AstType type) {
        MetricResult result = new MetricResult(survey.getSurvey(), (AstMember)type);
        survey.addResult(result);
        this.kind = this.readKind("kind");
        AstMethod[] methods = type.getExecutableFragments();
        ArrayList<MetricResult> methodResults = new ArrayList<MetricResult>(methods.length);
        int i = 0;
        while (i < methods.length) {
            if (!methods[i].isInitializer()) {
                MetricResult m = new MetricResult(survey.getSurvey(), (AstMember)methods[i]);
                methodResults.add(m);
                this.measure(methods[i], m);
            }
            ++i;
        }
        AstType[] types = type.getTypes();
        int i2 = 0;
        while (i2 < types.length) {
            this.survey(result, types[i2]);
            ++i2;
        }
        if ((this.kind == 0 || this.kind == 2) && this.measure(type, methodResults, result)) {
            result.aggregate();
        }
        if (this.kind == 1 || this.kind == 2) {
            Iterator i3 = ((AbstractList)methodResults).iterator();
            while (i3.hasNext()) {
                MetricResult m = (MetricResult)i3.next();
                result.addResult(m);
            }
        }
    }

    protected abstract boolean measure(AstType var1, ArrayList var2, MetricResult var3);

    private int readKind(String id) {
        IParameterStringEnum iParameterStringEnum = (IParameterStringEnum)this.getDescriptor().getParameterRegistry().getParameter(id, 4);
        if (iParameterStringEnum != null) {
            int kind = iParameterStringEnum.getOrdinalValue();
            switch (kind) {
                case 2: {
                    return 0;
                }
                case 3: {
                    return 1;
                }
            }
        }
        return 2;
    }
}

