/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstModel;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.CBO;
import com.togethersoft.sca.internal.plugin.metric.impl.ClassVisitor;

public class CF
extends ClassVisitor {
    private int totalClasses;
    private int totalCouplings;
    private CBO cbo = new CBO();

    protected void measure(AstModel model, MetricResult result) {
        this.totalClasses = 0;
        this.totalCouplings = 0;
        super.measure(model, result);
        if (this.totalClasses > 0) {
            result.setValue(this.totalCouplings, this.totalClasses * (this.totalClasses - 1));
        } else {
            result.setValue(0);
        }
    }

    protected void measureType(AstType type) {
        super.measureType(type);
        ++this.totalClasses;
        this.totalCouplings += this.cbo.measureCBO(type);
    }
}

