/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstDoStatement;
import com.togethersoft.sca.ast.AstForStatement;
import com.togethersoft.sca.ast.AstIfStatement;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.AstSwitchStatement;
import com.togethersoft.sca.ast.AstWhileStatement;
import com.togethersoft.sca.ast.visitor.AstStatementVisitor;
import com.togethersoft.sca.ast.visitor.AstStatementVisitorAdapter;
import com.togethersoft.sca.core.IParameterRegistry;

public class CCMeasurer
extends AstStatementVisitorAdapter {
    private boolean countCases;
    private int numCycles;

    public CCMeasurer(IParameterRegistry registry) {
        this.countCases = registry.getBooleanValue("Case as branch", false);
    }

    public int measure(AstStatement stmt) {
        this.numCycles = 1;
        if (stmt != null) {
            stmt.visitStatements((AstStatementVisitor)this);
        }
        return this.numCycles;
    }

    public void visitWhileStatement(AstWhileStatement stmt) {
        ++this.numCycles;
    }

    public void visitDoStatement(AstDoStatement stmt) {
        ++this.numCycles;
    }

    public void visitForStatement(AstForStatement stmt) {
        ++this.numCycles;
    }

    public void visitIfStatement(AstIfStatement stmt) {
        ++this.numCycles;
    }

    public void visitSwitchStatement(AstSwitchStatement stmt) {
        if (this.countCases) {
            this.numCycles += stmt.getBody().length;
        }
    }
}

