/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstModel;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.ClassVisitor;

public class AIF
extends ClassVisitor {
    private boolean countConstants;
    private int total;
    private int inherited;

    protected void measure(AstModel model, MetricResult result) {
        this.total = 0;
        this.inherited = 0;
        super.measure(model, result);
        if (this.total > 0) {
            result.setValue(this.inherited, this.total);
        } else {
            result.setValue(0);
        }
    }

    protected void measureType(AstType type) {
        super.measureType(type);
        AstField[] all = type.getAllFields();
        AstField[] declared = type.getFields();
        int numAll = all.length;
        int numDeclared = declared.length;
        if (type.isInterface()) {
            numAll = numDeclared;
        } else {
            int i = 0;
            while (i < all.length) {
                if (all[i].getDeclaringType().isInterface()) {
                    --numAll;
                }
                ++i;
            }
            if (!this.countConstants) {
                int i2 = 0;
                while (i2 < all.length) {
                    if (this.isConstant(all[i2])) {
                        --numAll;
                    }
                    ++i2;
                }
                int i3 = 0;
                while (i3 < declared.length) {
                    if (this.isConstant(declared[i3])) {
                        --numDeclared;
                    }
                    ++i3;
                }
            }
        }
        this.total += numAll;
        this.inherited += numAll - numDeclared;
    }

    private boolean isConstant(AstField field) {
        return field.isFinal() && field.isStatic() && field.getInitializer() != null && field.getInitializer().isConstant();
    }

    public void setDescriptor(IAnalyzerDescriptor descriptor) {
        super.setDescriptor(descriptor);
        this.countConstants = descriptor.getParameterRegistry().getBooleanValue("Count constants", true);
    }
}

