/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstMember;
import com.togethersoft.sca.ast.AstModel;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.ProjectMetric;

public class AHF
extends ProjectMetric {
    private int invisibilities;
    private int delta;
    private int numClasses;
    private int numMembers;

    protected void measure(AstModel model, MetricResult result) {
        this.invisibilities = 0;
        this.delta = 0;
        this.numClasses = 0;
        this.numMembers = 0;
        AstPackage[] packages = model.getPackages();
        int i = 0;
        while (i < packages.length) {
            this.measurePackage(packages[i]);
            ++i;
        }
        result.setValue(this.invisibilities * this.numClasses + this.delta, this.numMembers * (this.numClasses - 1));
    }

    private void measurePackage(AstPackage pkg) {
        AstPackage[] subpackages = pkg.getSubpackages();
        int i = 0;
        while (i < subpackages.length) {
            this.measurePackage(subpackages[i]);
            ++i;
        }
        AstCompilationUnit[] files = pkg.getCompilationUnits();
        int packageTypes = 0;
        int i2 = 0;
        while (i2 < files.length) {
            packageTypes += this.getNumTypes(files[i2].getTypes());
            ++i2;
        }
        int i3 = 0;
        while (i3 < files.length) {
            this.measureTypes(packageTypes, files[i3].getTypes());
            ++i3;
        }
    }

    private int getNumTypes(AstType[] types) {
        int numTypes = types.length;
        int i = 0;
        while (i < types.length) {
            numTypes += this.getNumTypes(types[i].getTypes());
            ++i;
        }
        return numTypes;
    }

    private void measureTypes(int packageTypes, AstType[] types) {
        int i = 0;
        while (i < types.length) {
            this.measureTypes(packageTypes, types[i].getTypes());
            ++this.numClasses;
            AstMember[] members = this.getMembers(types[i]);
            int j = 0;
            while (j < members.length) {
                this.measureMember(packageTypes, types[i], members[j]);
                ++j;
            }
            ++i;
        }
    }

    private void measureMember(int packageTypes, AstType type, AstMember member) {
        ++this.numMembers;
        if (member.isPublic() && type.isPublic()) {
            return;
        }
        ++this.invisibilities;
        if (member.isPublic() && type.isPackage() || member.isPackage() && type.isPublic() || member.isPackage() && type.isPackage()) {
            this.delta -= packageTypes + 1;
        } else if (member.isProtected()) {
            this.delta -= packageTypes + 1;
            this.delta -= this.countDerived(type.getPackage(), type.getSubtypes());
        } else {
            this.delta -= type.getTypes().length + 1;
        }
    }

    private int countDerived(AstPackage pkg, AstType[] types) {
        int derived = 0;
        int i = 0;
        while (i < types.length) {
            if (types[i].getPackage() != pkg) {
                ++derived;
            }
            derived += this.countDerived(pkg, types[i].getSubtypes());
            ++i;
        }
        return derived;
    }

    protected AstMember[] getMembers(AstType type) {
        return type.getFields();
    }
}

