/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric.impl;

import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.IParameter;
import com.togethersoft.sca.core.IParameterInteger;
import com.togethersoft.sca.core.IParameterList;
import com.togethersoft.sca.core.IParameterString;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.impl.ClassMetric;
import java.util.ArrayList;

public class AC
extends ClassMetric {
    private String[] typeNames;
    private Integer[] typeWeights;
    private int arrayWeight;
    private int othersWeight;

    public void setDescriptor(IAnalyzerDescriptor descriptor) {
        super.setDescriptor(descriptor);
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<Integer> weightList = new ArrayList<Integer>();
        IParameterList list = (IParameterList)descriptor.getParameterRegistry().getParameter("type-list", 5);
        if (list != null) {
            IParameter[] params = list.getParameterList();
            int i = 0;
            while (i < params.length) {
                if (params[i].getType() == 0) {
                    IParameterInteger ip = (IParameterInteger)params[i];
                    if (ip.getId().equals("*")) {
                        this.othersWeight = (int)ip.getValue();
                    } else if (ip.getId().equals("Array weight")) {
                        this.arrayWeight = (int)ip.getValue();
                    } else {
                        nameList.add(ip.getId().replace('.', '/'));
                        weightList.add(new Integer((int)ip.getValue()));
                    }
                } else if (params[i].getType() == 2) {
                    try {
                        IParameterString sp = (IParameterString)params[i];
                        int val = Integer.parseInt(sp.getValue());
                        nameList.add(sp.getId().replace('.', '/'));
                        weightList.add(new Integer(val));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        this.typeNames = nameList.toArray(new String[nameList.size()]);
        this.typeWeights = weightList.toArray(new Integer[weightList.size()]);
    }

    protected void measure(AstType subject, MetricResult result) {
        int total = 0;
        AstField[] fields = subject.getFields();
        int i = 0;
        while (i < fields.length) {
            total += this.measureField(fields[i]);
            ++i;
        }
        result.setValue(total);
    }

    private int measureField(AstField field) {
        AstTypeReference type = field.getType();
        if (type.numDimensions() > 0) {
            return this.arrayWeight;
        }
        String t = type.getTypeName();
        int i = 0;
        while (i < this.typeNames.length) {
            String pat;
            if (this.typeNames[i].endsWith("/*") ? t.indexOf(pat = this.typeNames[i].substring(0, this.typeNames[i].length() - 2)) == 0 : t.equals(this.typeNames[i])) {
                return this.typeWeights[i];
            }
            ++i;
        }
        return this.othersWeight;
    }
}

