/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric;

import com.togethersoft.sca.ast.AstMember;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.core.plugin.metric.IMetricResult;
import com.togethersoft.sca.core.plugin.metric.IMetricSurvey;
import java.util.ArrayList;

public class MetricResult
implements IMetricResult {
    private IMetricSurvey survey;
    private AstMember subject;
    private int numerator;
    private int denominator;
    private ArrayList results;
    private static final int AGGR_SUM = 1;
    private static final int AGGR_AVG = 2;
    private static final int AGGR_MIN = 3;
    private static final int AGGR_MAX = 4;

    public MetricResult(IMetricSurvey survey, AstMember subject) {
        this.survey = survey;
        this.subject = subject;
        this.results = new ArrayList();
        this.setVoid();
    }

    public IMetricSurvey getSurvey() {
        return this.survey;
    }

    public AstMember getSubject() {
        return this.subject;
    }

    public IMetricResult[] getResults() {
        return this.results.toArray(new IMetricResult[this.results.size()]);
    }

    public void addResult(IMetricResult result) {
        this.results.add(result);
    }

    public boolean isVoid() {
        return this.getValue() < 0;
    }

    public boolean isFraction() {
        return this.denominator != 0;
    }

    public int getValue() {
        if (this.denominator == 0) {
            return this.numerator;
        }
        int t = 100 * this.numerator;
        int result = t / this.denominator;
        if (t % this.denominator * 2 >= (this.denominator >= 0 ? this.denominator : -this.denominator)) {
            ++result;
        }
        return result;
    }

    public void setVoid() {
        this.numerator = -1;
        this.denominator = 0;
    }

    public void setValue(int value) {
        this.numerator = value;
        this.denominator = 0;
    }

    public void setValue(int numerator, int denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public String toString() {
        StringBuffer sbuf = this.subject != null ? new StringBuffer(this.subject.getQualifiedName()) : new StringBuffer("<project>");
        if (this.isVoid()) {
            return sbuf.toString();
        }
        return sbuf.append(": ").append(String.valueOf(this.getValue())).toString();
    }

    public void aggregate() {
        if (this.getSurvey().getMetric().getAggregation() == null) {
            return;
        }
        int aggrType = this.getSurvey().getMetric().getAggregation().getOrdinalValue();
        if (aggrType < 1 || this.results.size() == 0) {
            return;
        }
        int n = this.results.size() + (this.isVoid() ? 0 : 1);
        IMetricResult[] nested = new IMetricResult[n];
        this.results.toArray(nested);
        if (!this.isVoid()) {
            nested[nested.length - 1] = this;
        }
        int value = -1;
        switch (aggrType) {
            case 1: {
                int i = 0;
                while (i < nested.length) {
                    if (nested[i].getValue() >= 0) {
                        value = value >= 0 ? (value += nested[i].getValue()) : nested[i].getValue();
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                int count = 0;
                int sum = 0;
                int i = 0;
                while (i < nested.length) {
                    if (nested[i].getValue() >= 0) {
                        sum += nested[i].getValue();
                        ++count;
                    }
                    ++i;
                }
                if (count > 0) {
                    this.setValue(sum, count * 100);
                }
                return;
            }
            case 4: {
                int i = 0;
                while (i < nested.length) {
                    if (nested[i].getValue() >= 0) {
                        if (value >= 0) {
                            if (nested[i].getValue() > value) {
                                value = nested[i].getValue();
                            }
                        } else {
                            value = nested[i].getValue();
                        }
                    }
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 0;
                while (i < nested.length) {
                    if (nested[i].getValue() >= 0) {
                        if (value >= 0) {
                            if (nested[i].getValue() < value) {
                                value = nested[i].getValue();
                            }
                        } else {
                            value = nested[i].getValue();
                        }
                    }
                    ++i;
                }
                break;
            }
        }
        this.setValue(value);
    }

    public int getLowerLimit() {
        if (this.subject == null || this.subject instanceof AstPackage) {
            return this.getSurvey().getMetric().getLowerPackageLimit();
        }
        if (this.subject instanceof AstType) {
            return this.getSurvey().getMetric().getLowerClassLimit();
        }
        if (this.subject instanceof AstMethod) {
            return this.getSurvey().getMetric().getLowerMethodLimit();
        }
        return -1;
    }

    public int getUpperLimit() {
        if (this.subject == null || this.subject instanceof AstPackage) {
            return this.getSurvey().getMetric().getUpperPackageLimit();
        }
        if (this.subject instanceof AstType) {
            return this.getSurvey().getMetric().getUpperClassLimit();
        }
        if (this.subject instanceof AstMethod) {
            return this.getSurvey().getMetric().getUpperMethodLimit();
        }
        return -1;
    }
}

