/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric;

import com.togethersoft.sca.ast.AstMember;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.core.IAnalyzerCategory;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.IAnalyzerRegistry;
import com.togethersoft.sca.core.ICodeInspectorExecutable;
import com.togethersoft.sca.core.ILog;
import com.togethersoft.sca.core.IMessage;
import com.togethersoft.sca.core.IParameter;
import com.togethersoft.sca.core.IParameterRegistry;
import com.togethersoft.sca.core.IParameterString;
import com.togethersoft.sca.core.IProject;
import com.togethersoft.sca.core.JobControl;
import com.togethersoft.sca.core.Message;
import com.togethersoft.sca.core.plugin.metric.IMetric;
import com.togethersoft.sca.core.plugin.metric.IMetricContext;
import com.togethersoft.sca.core.plugin.metric.IMetricPlugin;
import com.togethersoft.sca.core.plugin.metric.IMetricResult;
import com.togethersoft.sca.core.plugin.metric.IMetricSurvey;
import com.togethersoft.sca.internal.core.ParameterStringEnum;
import com.togethersoft.sca.internal.core.StaticAnalyzer;
import com.togethersoft.sca.internal.plugin.metric.Metric;
import com.togethersoft.sca.internal.plugin.metric.MetricMessage;
import com.togethersoft.sca.internal.plugin.metric.impl.TableOfUsedMembers;
import java.util.HashMap;
import java.util.ResourceBundle;

public class MetricPlugin
implements IMetricPlugin,
IMetricContext,
ICodeInspectorExecutable {
    private HashMap metrics = new HashMap();
    private ILog log;
    private boolean XMLOutput;
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle("com.togethersoft.sca.internal.plugin.metric.MetricPluginMessages");
    public static final String AGGREGATION_ID = "Aggregation";
    public static String[] aggregations = new String[]{"None", "Sum", "Average", "Minimum", "Maximum", "Median"};

    public static ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    public IMetric getMetric(IAnalyzerDescriptor descriptor) {
        IMetric m = (IMetric)this.metrics.get(descriptor.getId());
        if (m == null && (m = this.getMetric(null, descriptor)) != null) {
            this.metrics.put(descriptor.getId(), m);
        }
        return m;
    }

    public IMetricSurvey[] measure(IProject project, IMetric[] metrics, JobControl jobControl) {
        IMetricSurvey[] measures = new IMetricSurvey[metrics.length];
        double delta = 0.0;
        if (jobControl != null) {
            if (metrics.length > 0) {
                delta = 1.0 / (double)metrics.length;
            } else {
                jobControl.update(1.0);
            }
        }
        int i = 0;
        while (i < metrics.length) {
            if (metrics[i] != null) {
                measures[i] = metrics[i].survey(project.getModel());
                if (jobControl != null) {
                    if (jobControl.isCanceled()) {
                        TableOfUsedMembers.reset();
                        return new IMetricSurvey[0];
                    }
                    jobControl.update(delta);
                }
            }
            ++i;
        }
        TableOfUsedMembers.reset();
        return measures;
    }

    public void setParameters(IParameterRegistry registry) {
    }

    public void configureRegistry(IAnalyzerRegistry registry) {
        IAnalyzerCategory[] categories = registry.getCategories();
        int i = 0;
        while (i < categories.length) {
            this.configureCategory(categories[i]);
            ++i;
        }
        IAnalyzerDescriptor[] analyzers = registry.getDescriptors();
        int i2 = 0;
        while (i2 < analyzers.length) {
            this.configureAnalyzer(analyzers[i2]);
            ++i2;
        }
    }

    private void configureCategory(IAnalyzerCategory category) {
        IAnalyzerCategory[] categories = category.getCategories();
        int i = 0;
        while (i < categories.length) {
            this.configureCategory(categories[i]);
            ++i;
        }
        IAnalyzerDescriptor[] analyzers = category.getDescriptors();
        int i2 = 0;
        while (i2 < analyzers.length) {
            this.configureAnalyzer(analyzers[i2]);
            ++i2;
        }
    }

    private void configureAnalyzer(IAnalyzerDescriptor analyzer) {
        IParameterRegistry registry = analyzer.getParameterRegistry();
        if (registry.getParameter(AGGREGATION_ID, 4) != null) {
            return;
        }
        ParameterStringEnum parameterStringEnum = new ParameterStringEnum(AGGREGATION_ID, AGGREGATION_ID, aggregations);
        parameterStringEnum.setValue(0);
        IParameterString param = (IParameterString)registry.getParameter(AGGREGATION_ID, 2);
        if (param != null) {
            if (!parameterStringEnum.setValue(param.getValue())) {
                StaticAnalyzer.getInstance().getLog().log((IMessage)new Message(2, MetricPlugin.getResourceBundle().getString("MetricPlugin.1"), new Object[]{analyzer.getId()}));
            }
            registry.removeParameter(AGGREGATION_ID, true);
        }
        registry.addParameter((IParameter)parameterStringEnum);
    }

    public void run(IProject project, IAnalyzerDescriptor[] analyzers, JobControl jobControl) {
        this.log = project.getLog();
        this.XMLOutput = this.log.isXML();
        IMetric[] metrics = new IMetric[analyzers.length];
        int i = 0;
        while (i < analyzers.length) {
            metrics[i] = this.getMetric(this.log, analyzers[i]);
            ++i;
        }
        IMetricSurvey[] surveys = this.measure(project, metrics, jobControl);
        this.report(surveys);
    }

    private IMetric getMetric(ILog log, IAnalyzerDescriptor descriptor) {
        Metric metric;
        block2: {
            metric = null;
            try {
                String cls = "com.togethersoft.sca.internal.plugin.metric.impl." + descriptor.getImplementation();
                Class<?> clazz = Class.forName(cls);
                metric = (Metric)clazz.newInstance();
                metric.setContext(this);
                metric.setDescriptor(descriptor);
            }
            catch (Exception e) {
                if (log == null) break block2;
                log.log((IMessage)new Message(2, MetricPlugin.getResourceBundle().getString("MetricPlugin.2"), new Object[]{e.getMessage()}));
            }
        }
        return metric;
    }

    private void report(IMetricSurvey[] surveys) {
        if (this.XMLOutput) {
            this.log.log("<metric>");
        }
        int i = 0;
        while (i < surveys.length) {
            if (surveys[i] != null) {
                IMetricSurvey survey = surveys[i];
                if (this.XMLOutput) {
                    this.log.log("<survey id=\"" + survey.getMetric().getDescriptor().getId() + "\">");
                }
                IMetricResult[] results = survey.getResults();
                int j = 0;
                while (j < results.length) {
                    this.logResults(survey, results[j]);
                    ++j;
                }
                if (this.XMLOutput) {
                    this.log.log("</survey>");
                }
            }
            ++i;
        }
        if (this.XMLOutput) {
            this.log.log("</metric>");
        }
    }

    private void logResults(IMetricSurvey survey, IMetricResult result) {
        if (this.XMLOutput) {
            String target;
            this.log.log("\t<metricresult>");
            AstMember subject = result.getSubject();
            if (subject != null) {
                this.log.log("\t\t<property name=\"subject\" value=\"" + subject.getQualifiedName() + "\" />");
                if (subject.getObjectKind() == 7) {
                    target = "package";
                } else if (subject.getObjectKind() == 8) {
                    target = "class";
                } else {
                    target = "method";
                    this.log.log("\t\t<property name=\"signature\" value=\"" + ((AstMethod)subject).getSignature() + "\" />");
                }
            } else {
                target = "project";
                this.log.log("\t\t<property name=\"subject\" value=\"&lt;project&gt;\" />");
            }
            this.log.log("\t\t<property name=\"measure\" value=\"" + result.getValue() + "\" />");
            this.log.log("\t\t<property name=\"target\" value=\"" + target + "\" />");
            this.log.log("\t</metricresult>");
        } else {
            IAnalyzerDescriptor desc = survey.getMetric().getDescriptor();
            String msg = desc.getId() + ": " + result;
            this.log.log((IMessage)new MetricMessage(msg, desc, result.getSubject(), result));
        }
        IMetricResult[] nested = result.getResults();
        int i = 0;
        while (i < nested.length) {
            this.logResults(survey, nested[i]);
            ++i;
        }
    }
}

