/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.metric;

import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstMember;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstModel;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.IParameterInteger;
import com.togethersoft.sca.core.IParameterStringEnum;
import com.togethersoft.sca.core.plugin.metric.IMetric;
import com.togethersoft.sca.core.plugin.metric.IMetricContext;
import com.togethersoft.sca.core.plugin.metric.IMetricSurvey;
import com.togethersoft.sca.internal.plugin.metric.MetricResult;
import com.togethersoft.sca.internal.plugin.metric.MetricSurvey;

public abstract class Metric
implements IMetric {
    private IMetricContext context;
    private IAnalyzerDescriptor descriptor;

    public IMetricContext getContext() {
        return this.context;
    }

    public void setContext(IMetricContext context) {
        this.context = context;
    }

    public IAnalyzerDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(IAnalyzerDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public abstract int getKind();

    public IMetricSurvey survey(AstModel model) {
        MetricSurvey survey = new MetricSurvey(this, model);
        MetricResult result = new MetricResult(survey, null);
        AstPackage[] pkgs = model.getPackages();
        int i = 0;
        while (i < pkgs.length) {
            this.survey(result, pkgs[i]);
            ++i;
        }
        result.aggregate();
        survey.addResult(result);
        return survey;
    }

    protected boolean survey(MetricResult survey, AstPackage pkg) {
        MetricResult result = new MetricResult(survey.getSurvey(), (AstMember)pkg);
        AstCompilationUnit[] units = pkg.getCompilationUnits();
        boolean ret = units.length > 0;
        int i = 0;
        while (i < units.length) {
            this.survey(result, units[i]);
            ++i;
        }
        AstPackage[] pkgs = pkg.getSubpackages();
        int i2 = 0;
        while (i2 < pkgs.length) {
            ret |= this.survey(result, pkgs[i2]);
            ++i2;
        }
        result.aggregate();
        if (ret) {
            survey.addResult(result);
        }
        return ret;
    }

    private final void survey(MetricResult result, AstCompilationUnit unit) {
        AstType[] types = unit.getTypes();
        int i = 0;
        while (i < types.length) {
            this.survey(result, types[i]);
            ++i;
        }
    }

    protected void survey(MetricResult survey, AstType type) {
        MetricResult result = new MetricResult(survey.getSurvey(), (AstMember)type);
        survey.addResult(result);
        AstType[] types = type.getTypes();
        int i = 0;
        while (i < types.length) {
            this.survey(result, types[i]);
            ++i;
        }
        AstMethod[] methods = type.getExecutableFragments();
        int i2 = 0;
        while (i2 < methods.length) {
            if (!methods[i2].isInitializer()) {
                this.survey(result, methods[i2]);
            }
            ++i2;
        }
        result.aggregate();
    }

    protected void survey(MetricResult survey, AstMethod method) {
    }

    public int getLowerPackageLimit() {
        IParameterInteger param = (IParameterInteger)this.getDescriptor().getParameterRegistry().getParameter("PackageLowerLimit", 0);
        return param != null ? (int)param.getValue() : 0;
    }

    public int getLowerClassLimit() {
        IParameterInteger param = (IParameterInteger)this.getDescriptor().getParameterRegistry().getParameter("ClassLowerLimit", 0);
        return param != null ? (int)param.getValue() : 0;
    }

    public int getLowerMethodLimit() {
        IParameterInteger param = (IParameterInteger)this.getDescriptor().getParameterRegistry().getParameter("MethodLowerLimit", 0);
        return param != null ? (int)param.getValue() : 0;
    }

    public int getUpperPackageLimit() {
        IParameterInteger param = (IParameterInteger)this.getDescriptor().getParameterRegistry().getParameter("PackageUpperLimit", 0);
        return param != null ? (int)param.getValue() : 0;
    }

    public int getUpperClassLimit() {
        IParameterInteger param = (IParameterInteger)this.getDescriptor().getParameterRegistry().getParameter("ClassUpperLimit", 0);
        return param != null ? (int)param.getValue() : 0;
    }

    public int getUpperMethodLimit() {
        IParameterInteger param = (IParameterInteger)this.getDescriptor().getParameterRegistry().getParameter("MethodUpperLimit", 0);
        return param != null ? (int)param.getValue() : 0;
    }

    public IParameterStringEnum getAggregation() {
        return (IParameterStringEnum)this.descriptor.getParameterRegistry().getParameter("Aggregation", 4);
    }
}

