/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.devel.wizards;

import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class JavaTestWizardPage
extends WizardPage {
    private StringDialogField fPseudoCommentDialogField;
    private StringDialogField fResBundleCommentDialogField;

    public JavaTestWizardPage(String pageName) {
        super(pageName);
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.fPseudoCommentDialogField = new StringDialogField();
        this.fPseudoCommentDialogField.setLabelText("pseudocomment ID");
        this.fPseudoCommentDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                JavaTestWizardPage.this.handlePseudoCommentChanged();
            }
        });
        this.fResBundleCommentDialogField = new StringDialogField();
        this.fResBundleCommentDialogField.setLabelText("resource bundle");
        this.fResBundleCommentDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                JavaTestWizardPage.this.handleResBundleChanged();
            }
        });
        this.createPseudoCommentControls(composite, nColumns);
        this.createResBundleControls(composite, nColumns);
        this.setControl((Control)composite);
    }

    private void createPseudoCommentControls(Composite composite, int nColumns) {
        this.fPseudoCommentDialogField.doFillIntoGrid(composite, nColumns - 1);
        DialogField.createEmptySpace((Composite)composite);
        LayoutUtil.setWidthHint((Control)this.fPseudoCommentDialogField.getTextControl(null), (int)this.getMaxFieldWidth());
    }

    private void createResBundleControls(Composite composite, int nColumns) {
        this.fResBundleCommentDialogField.doFillIntoGrid(composite, nColumns - 1);
        DialogField.createEmptySpace((Composite)composite);
        LayoutUtil.setWidthHint((Control)this.fResBundleCommentDialogField.getTextControl(null), (int)this.getMaxFieldWidth());
    }

    private int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(40);
    }

    private void handlePseudoCommentChanged() {
        String commentId = this.fPseudoCommentDialogField.getText().trim();
        boolean commentOk = commentId.equals(commentId.toUpperCase());
        this.setPageComplete(commentOk);
        if (!commentOk) {
            this.setErrorMessage("must be uppercase");
        } else {
            this.setErrorMessage(null);
        }
    }

    private void handleResBundleChanged() {
    }

    public String getResourceBundleName() {
        return this.fResBundleCommentDialogField.getText().trim();
    }

    public String getPseudoCommentName() {
        return this.fPseudoCommentDialogField.getText().trim();
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public IWizardPage getNextPage() {
        return null;
    }
}

