/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.jom.devel.wizards;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class JavaMetricWizardPage
extends WizardPage {
    private static String[] STATISTIC_NAMES = new String[]{"Sum", "Average", "Max", "Min", "Standard Deviation"};
    private StringDialogField fMetricNames;
    private SelectionButtonDialogFieldGroup fStatistics;

    public JavaMetricWizardPage(String pageName) {
        super(pageName);
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.fMetricNames = new StringDialogField();
        this.fMetricNames.setLabelText("metric name(s) [comma-separated]");
        this.fMetricNames.doFillIntoGrid(composite, nColumns);
        this.fStatistics = new SelectionButtonDialogFieldGroup(32, STATISTIC_NAMES, 1);
        this.fStatistics.setLabelText("Statistics");
        this.fStatistics.setSelection(0, true);
        this.fStatistics.setSelection(2, true);
        this.fStatistics.setSelection(3, true);
        this.createStatisticsControls(composite, nColumns);
        this.setControl((Control)composite);
    }

    private void createStatisticsControls(Composite composite, int nColumns) {
        this.fStatistics.doFillIntoGrid(composite, nColumns);
        DialogField.createEmptySpace((Composite)composite);
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public String getStatistics() {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        int i = 0;
        while (i < STATISTIC_NAMES.length) {
            if (this.fStatistics.isSelected(i)) {
                String add;
                switch (i) {
                    case 0: {
                        add = "MetricInfo.SUM";
                        break;
                    }
                    case 1: {
                        add = "MetricInfo.AVERAGE";
                        break;
                    }
                    case 2: {
                        add = "MetricInfo.MAX";
                        break;
                    }
                    case 3: {
                        add = "MetricInfo.MIN";
                        break;
                    }
                    case 4: {
                        add = "MetricInfo.STD_DEV";
                        break;
                    }
                    default: {
                        add = null;
                    }
                }
                if (add != null) {
                    buf.append(first ? add : " | " + add);
                    first = false;
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public String[] getMetricNames() {
        StringTokenizer tok = new StringTokenizer(this.fMetricNames.getText(), ",", false);
        ArrayList<String> metricNames = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            metricNames.add(tok.nextToken().trim());
        }
        return metricNames.toArray(new String[0]);
    }
}

