/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.serialization;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayType;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleType;
import com.sap.tc.jtools.jlint.jom.interfaces.IType;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.util.InheritanceTool;
import com.sap.tc.jtools.jlint.jom.util.NameTool;
import com.sap.tc.jtools.jlint.jom.util.PrimitiveTypeTool;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Properties;
import java.util.Stack;

public class SerializableTest
extends JomTestVisitor {
    private static final String NAME = "Serialization";
    private static final String SER_VER_UID_NAME = "serialVersionUID";
    private static final String SER_PERS_FIELDS_NAME = "serialPersistentFields";
    private static final String WRITE_OBJECT_NAME = "writeObject";
    private static final String READ_OBJECT_NAME = "readObject";
    private static final String WRITE_REPLACE_NAME = "writeReplace";
    private static final String READ_RESOLVE_NAME = "readResolve";
    private static final String OUT_STREAM_NAME = "java.io.ObjectOutputStream";
    private static final String IN_STREAM_NAME = "java.io.ObjectInputStream";
    private static final String OBJECT_NAME = "java.lang.Object";
    private static final String SERIALIZABLE_NAME = "java.io.Serializable";
    private static final String EXTERNALIZABLE_NAME = "java.io.Externalizable";
    private static final String OBJ_STR_FIELD_NAME = "java.io.ObjectStreamField";
    private static final String MSG_KEY_1 = "serialization.1";
    private static final String MSG_KEY_2 = "serialization.2";
    private static final String MSG_KEY_3 = "serialization.3";
    private static final String MSG_KEY_4 = "serialization.4";
    private static final String MSG_KEY_5 = "serialization.5";
    private static final String PARAM_SUPERCLASS = "SUPER_CLASS";
    private static final String INPUT_PARAM_IGNORE_GUI_CLASSES = "IGNORE_GUI_CLASSES";
    private static final String INPUT_PARAM_CHECK_SERIALVERSION_UID = "CHECK_SERIALVERSION_UID";
    private Stack attributeStack = new Stack();
    private boolean ignoreGUIClasses = false;
    private boolean checkSerialVersionUID = false;
    private static final String AWT_PREFIX = "java.awt";
    private static final String SWING_PREFIX = "javax.swing";

    public String getTestName() {
        return NAME;
    }

    public void setParameters(ParameterInterface[] parameters, TestObject testObject) {
        super.setParameters(parameters, testObject);
        this.ignoreGUIClasses = (Boolean)this.getInputParameter(INPUT_PARAM_IGNORE_GUI_CLASSES);
        this.checkSerialVersionUID = (Boolean)this.getInputParameter(INPUT_PARAM_CHECK_SERIALVERSION_UID);
    }

    public boolean visit(ITypeDeclaration node) {
        this.attributeStack.push(new Attributes());
        IReferenceTypeBinding bnd = node.resolveBinding();
        if (bnd == null || !bnd.isClass()) {
            return false;
        }
        if (InheritanceTool.bndImplements((IReferenceTypeBinding)bnd, (String)SERIALIZABLE_NAME) && !InheritanceTool.bndImplements((IReferenceTypeBinding)bnd, (String)EXTERNALIZABLE_NAME)) {
            if (this.ignoreGUIClasses && SerializableTest.isGuiClass(bnd)) {
                return false;
            }
            ((Attributes)this.attributeStack.peek()).implementsSerializable = true;
            this.checkForMagicFields(node);
            this.checkForMagicMethods(node);
            this.checkSuperClasses(bnd, (Position)node);
            this.checkConsistency((Position)node);
            return true;
        }
        return false;
    }

    private static boolean isGuiClass(IReferenceTypeBinding bnd) {
        IReferenceTypeBinding currentBnd = bnd;
        String className = null;
        while (currentBnd.getSuperclass() != null) {
            className = currentBnd.getName();
            if (className.startsWith(AWT_PREFIX) || className.startsWith(SWING_PREFIX)) {
                return true;
            }
            currentBnd = currentBnd.getSuperclass();
        }
        return false;
    }

    private void checkConsistency(Position pos) {
        Attributes attr = (Attributes)this.attributeStack.peek();
        if (attr.readObjectDeclared != attr.writeObjectDeclared) {
            this.addError(MSG_KEY_1, null, pos);
        }
        if (attr.serialPersistentFieldsDeclared && (attr.readObjectDeclared || attr.writeObjectDeclared)) {
            this.addError(MSG_KEY_2, null, pos);
        }
    }

    private void checkSuperClasses(IReferenceTypeBinding bnd, Position pos) {
        if (InheritanceTool.bndImplements((IReferenceTypeBinding)bnd, (String)SERIALIZABLE_NAME)) {
            this.checkSuperClasses(bnd.getSuperclass(), pos);
        } else {
            IMethodBinding[] methods = bnd.getDeclaredMethods();
            boolean constrFound = false;
            int i = 0;
            while (i < methods.length) {
                if (methods[i].isConstructor()) {
                    constrFound = true;
                    break;
                }
                ++i;
            }
            if (!constrFound) {
                return;
            }
            boolean noArgConstrFound = false;
            int i2 = 0;
            while (i2 < methods.length) {
                if (methods[i2].isConstructor() && methods[i2].getParameterTypes().length == 0) {
                    noArgConstrFound = true;
                    break;
                }
                ++i2;
            }
            if (!noArgConstrFound) {
                Properties p = new Properties();
                p.setProperty(PARAM_SUPERCLASS, NameTool.getFullClassName((ITypeBinding)bnd));
                this.addError(MSG_KEY_3, p, pos);
            }
        }
    }

    private void checkForMagicMethods(ITypeDeclaration node) {
        Attributes attr = (Attributes)this.attributeStack.peek();
        IMethodDeclaration[] methods = node.getMethods();
        int i = 0;
        while (i < methods.length) {
            boolean writeReplDecl;
            String methName = methods[i].getName();
            List params = methods[i].parameters();
            IType returnType = methods[i].getReturnType();
            boolean bl = writeReplDecl = WRITE_REPLACE_NAME.equals(methName) && params.size() == 0 && OBJECT_NAME.equals(NameTool.getFullClassName((ITypeBinding)returnType.resolveBinding()));
            if (writeReplDecl) {
                attr.writeReplaceDeclared = true;
            } else {
                boolean readResDecl;
                boolean bl2 = readResDecl = READ_RESOLVE_NAME.equals(methName) && params.size() == 0 && OBJECT_NAME.equals(NameTool.getFullClassName((ITypeBinding)returnType.resolveBinding()));
                if (readResDecl) {
                    attr.readResolveDeclared = true;
                } else {
                    boolean writeObjDecl = false;
                    if (WRITE_OBJECT_NAME.equals(methName) && params.size() == 1) {
                        IVariableDeclaration param = (IVariableDeclaration)params.get(0);
                        boolean bl3 = writeObjDecl = OUT_STREAM_NAME.equals(NameTool.getFullClassName((ITypeBinding)param.getType().resolveBinding())) && Modifier.isPrivate(methods[i].getModifiers()) && returnType.isPrimitiveType() && NameTool.toDotNotation((String[])((ISimpleType)returnType).getName()).equals("void");
                    }
                    if (writeObjDecl) {
                        attr.writeObjectDeclared = true;
                    } else {
                        boolean readObjDecl = false;
                        if (READ_OBJECT_NAME.equals(methName) && params.size() == 1) {
                            IVariableDeclaration param = (IVariableDeclaration)params.get(0);
                            boolean bl4 = readObjDecl = IN_STREAM_NAME.equals(NameTool.getFullClassName((ITypeBinding)param.getType().resolveBinding())) && Modifier.isPrivate(methods[i].getModifiers()) && returnType.isPrimitiveType() && NameTool.toDotNotation((String[])((ISimpleType)returnType).getName()).equals("void");
                        }
                        if (readObjDecl) {
                            attr.readObjectDeclared = true;
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void checkForMagicFields(ITypeDeclaration node) {
        Attributes attr = (Attributes)this.attributeStack.peek();
        IFieldDeclaration[] decls = node.getFields();
        int i = 0;
        while (i < decls.length) {
            int mod = decls[i].getModifiers();
            if (Modifier.isStatic(mod) && Modifier.isFinal(mod)) {
                IType declType = decls[i].getType();
                if (!attr.serialVersionUIDDeclared) {
                    boolean bl = attr.serialVersionUIDDeclared = decls[i].getName().equals(SER_VER_UID_NAME) && PrimitiveTypeTool.isLong((ITypeBinding)declType.resolveBinding());
                }
                if (!attr.serialPersistentFieldsDeclared) {
                    attr.serialPersistentFieldsDeclared = SER_PERS_FIELDS_NAME.equals(decls[i].getName()) && declType.isArrayType() && ((IArrayType)declType).getDimensions() == 1 && OBJ_STR_FIELD_NAME.equals(NameTool.getFullClassName((ITypeBinding)((IArrayTypeBinding)declType.resolveBinding()).getElementType()));
                }
            }
            ++i;
        }
    }

    private void addSerialUIDWarning(Position pos) {
        this.addError(MSG_KEY_4, null, pos);
    }

    public boolean visit(IFieldDeclaration node) {
        Attributes attr = (Attributes)this.attributeStack.peek();
        if (attr.serialPersistentFieldsDeclared || attr.writeObjectDeclared || attr.readObjectDeclared) {
            return true;
        }
        int mod = node.getModifiers();
        if (Modifier.isStatic(mod) || Modifier.isTransient(mod)) {
            return true;
        }
        IType type = node.getType();
        if (type.isPrimitiveType()) {
            return true;
        }
        if (type.isArrayType()) {
            ITypeBinding bnd = ((IArrayType)type).getElementType();
            if (bnd.isPrimitive()) {
                return true;
            }
        } else {
            ITypeBinding bnd = type.resolveBinding();
            if (!InheritanceTool.bndImplements((IReferenceTypeBinding)((IReferenceTypeBinding)bnd), (String)SERIALIZABLE_NAME)) {
                this.addError(MSG_KEY_5, null, (Position)node);
            }
        }
        return true;
    }

    public void endVisit(ITypeDeclaration node) {
        Attributes attr = (Attributes)this.attributeStack.peek();
        if (this.checkSerialVersionUID && attr.implementsSerializable && !attr.serialVersionUIDDeclared) {
            this.addSerialUIDWarning((Position)node);
        }
        this.attributeStack.pop();
    }

    private class Attributes {
        boolean implementsSerializable = false;
        boolean serialVersionUIDDeclared = false;
        boolean serialPersistentFieldsDeclared = false;
        boolean writeObjectDeclared = false;
        boolean readObjectDeclared = false;
        boolean writeReplaceDeclared = false;
        boolean readResolveDeclared = false;

        private Attributes() {
        }
    }
}

