/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.rc;

import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IPackageBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding;
import com.sap.tc.jtools.jlint.tests.rc.RCConstants;
import com.sap.tc.jtools.jlint.tests.rc.RCPackage;
import com.sap.tc.jtools.jlint.tests.rc.RCStatusInfo;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class RestrictedComponents
implements RCConstants {
    public static final String PACKAGE_ROOT_NAME = "";
    public static final String ATTR_DEFAULT_STATUS = "DEFAULT_STATUS";
    public static final String ATTR_DEFAULT_PRIO = "DEFAULT_PRIORITY";
    private RCPackage[] packages;
    private RCStatusInfo defaultStatusForRoot;
    private String defaultStatus;
    private int defaultPrio;

    public RestrictedComponents(StructureTree tree) {
        String defaultPrioString;
        Header topHeader = tree.getHeader();
        this.defaultStatus = topHeader.getParameter(ATTR_DEFAULT_STATUS);
        if (this.defaultStatus == null) {
            this.defaultStatus = "Forbidden";
        }
        this.defaultPrio = (defaultPrioString = topHeader.getParameter(ATTR_DEFAULT_PRIO)) == null ? 1 : Integer.parseInt(defaultPrioString.trim());
        this.defaultStatusForRoot = new RCStatusInfo(PACKAGE_ROOT_NAME, this.defaultStatus, this.defaultPrio, null, Collections.EMPTY_LIST);
        RCPackage pkgRoot = new RCPackage(PACKAGE_ROOT_NAME, null, null, this.defaultStatusForRoot);
        StructureTree[] pkgTrees = tree.getChildren("PACKAGE");
        this.packages = new RCPackage[pkgTrees.length];
        int i = 0;
        while (i < pkgTrees.length) {
            this.packages[i] = new RCPackage(pkgTrees[i], pkgRoot);
            ++i;
        }
    }

    public RCStatusInfo getStatusInfo(IBinding caller, IBinding callee) {
        if (!(caller instanceof IPackageBinding || caller instanceof IReferenceTypeBinding || caller instanceof IMethodBinding)) {
            throw new IllegalArgumentException("illegal caller type: " + caller.getClass().getName());
        }
        if (!(callee instanceof IPackageBinding || callee instanceof IReferenceTypeBinding || callee instanceof IVariableBinding || callee instanceof IMethodBinding)) {
            throw new IllegalArgumentException("illegal callee type: " + callee.getClass().getName());
        }
        if (callee instanceof IVariableBinding && !((IVariableBinding)callee).isField()) {
            throw new IllegalArgumentException("callee must be a field: " + ((IVariableBinding)callee).getName());
        }
        String callerString = RestrictedComponents.getString(caller);
        String[] calleeStringArray = RestrictedComponents.getCalleeArray(callee);
        if (calleeStringArray.length == 0) {
            return this.defaultStatusForRoot;
        }
        int i = 0;
        while (i < this.packages.length) {
            if (calleeStringArray[0].equals(this.packages[i].getName())) {
                return this.packages[i].getStatusInfo(callerString, calleeStringArray, 1);
            }
            ++i;
        }
        return new RCStatusInfo(this.getCalleeString(callee), this.defaultStatus, this.defaultPrio, null, Collections.EMPTY_LIST);
    }

    public static String getString(IBinding bnd) {
        String callerString = null;
        if (bnd instanceof IPackageBinding) {
            callerString = RestrictedComponents.getCallerString((IPackageBinding)bnd);
        } else if (bnd instanceof IReferenceTypeBinding) {
            callerString = RestrictedComponents.getCallerString((IReferenceTypeBinding)bnd);
        } else if (bnd instanceof IMethodBinding) {
            callerString = RestrictedComponents.getCallerString((IMethodBinding)bnd);
        } else if (bnd instanceof IVariableBinding) {
            callerString = RestrictedComponents.getCallerString((IVariableBinding)bnd);
        } else {
            throw new IllegalArgumentException();
        }
        return callerString;
    }

    private String getCalleeString(IBinding callee) {
        StringBuffer buf = new StringBuffer();
        String[] components = RestrictedComponents.getCalleeArray(callee);
        int i = 0;
        while (i < components.length) {
            buf.append(i == 0 ? components[i] : "." + components[i]);
            ++i;
        }
        return buf.toString();
    }

    private static String[] getCalleeArray(IBinding callee) {
        String[] calleeString = null;
        if (callee instanceof IPackageBinding) {
            calleeString = RestrictedComponents.getCalleeArray((IPackageBinding)callee);
        } else if (callee instanceof IReferenceTypeBinding) {
            calleeString = RestrictedComponents.getCalleeArray((IReferenceTypeBinding)callee);
        } else if (callee instanceof IMethodBinding) {
            calleeString = RestrictedComponents.getCalleeArray((IMethodBinding)callee);
        } else if (callee instanceof IVariableBinding) {
            calleeString = RestrictedComponents.getCalleeArray((IVariableBinding)callee);
        } else {
            throw new IllegalArgumentException();
        }
        return calleeString;
    }

    private static String[] getCalleeArray(IVariableBinding variable) {
        ITypeBinding declClass = variable.getDeclaringClass();
        if (!(declClass instanceof IReferenceTypeBinding)) {
            return new String[0];
        }
        List classComponents = RestrictedComponents.getCalleeList((IReferenceTypeBinding)declClass);
        classComponents.add(variable.getName());
        return classComponents.toArray(new String[0]);
    }

    private static String[] getCalleeArray(IMethodBinding method) {
        StringBuffer methodKey = new StringBuffer(30);
        if (method.isConstructor()) {
            methodKey.append(method.getDeclaringClass().getIdentifier());
        } else {
            methodKey.append(method.getName());
        }
        methodKey.append("@");
        ITypeBinding[] paramTypes = method.getParameterTypes();
        int k = 0;
        while (k < paramTypes.length) {
            methodKey.append(paramTypes[k].getName());
            methodKey.append(";");
            ++k;
        }
        List components = RestrictedComponents.getCalleeList(method.getDeclaringClass());
        components.add(methodKey.toString());
        return components.toArray(new String[0]);
    }

    private static String[] getCalleeArray(IReferenceTypeBinding refType) {
        return RestrictedComponents.getCalleeList(refType).toArray(new String[0]);
    }

    private static String getCallerString(IReferenceTypeBinding refType) {
        return RestrictedComponents.dotConcat(RestrictedComponents.getCalleeArray(refType));
    }

    private static String getCallerString(IMethodBinding meth) {
        return RestrictedComponents.dotConcat(RestrictedComponents.getCalleeArray(meth));
    }

    private static String getCallerString(IVariableBinding var) {
        return RestrictedComponents.dotConcat(RestrictedComponents.getCalleeArray(var));
    }

    private static String getCallerString(IPackageBinding pkgBnd) {
        return RestrictedComponents.dotConcat(RestrictedComponents.getCalleeArray(pkgBnd));
    }

    private static String[] getCalleeArray(IPackageBinding pkgBnd) {
        return pkgBnd.getNameComponents();
    }

    private static String dotConcat(String[] string) {
        StringBuffer tmp = new StringBuffer();
        int i = 0;
        while (i < string.length) {
            tmp.append((i == 0 ? PACKAGE_ROOT_NAME : ".") + string[i]);
            ++i;
        }
        return tmp.toString();
    }

    private static List getCalleeList(IReferenceTypeBinding refType) {
        ArrayList<String> tmpList = new ArrayList<String>();
        IPackageBinding pkgBnd = refType.getPackage();
        if (pkgBnd != null) {
            tmpList.addAll(Arrays.asList(pkgBnd.getNameComponents()));
        }
        ArrayList<String> classList = new ArrayList<String>();
        classList.add(refType.getIdentifier());
        IReferenceTypeBinding currentBinding = refType;
        while (currentBinding.getDeclaringClass() != null) {
            classList.add(currentBinding.getDeclaringClass().getIdentifier());
            currentBinding = currentBinding.getDeclaringClass();
        }
        Collections.reverse(classList);
        tmpList.addAll(classList);
        return tmpList;
    }
}

