/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.rc;

import com.sap.tc.jtools.jlint.tests.rc.RCClass;
import com.sap.tc.jtools.jlint.tests.rc.RCConstants;
import com.sap.tc.jtools.jlint.tests.rc.RCStatusInfo;
import com.sap.tc.jtools.util.structures.StructureTree;
import java.util.ArrayList;
import java.util.Iterator;

class RCPackage
implements RCConstants {
    public static final String PACKAGE_SEPARATOR = ".";
    private String name;
    private RCPackage[] directSubPackages;
    private RCClass[] classes;
    private RCStatusInfo statusInfo;
    private RCStatusInfo statusInfoInexactMatch;

    public RCPackage(StructureTree packageTree, RCPackage parent) {
        this.name = packageTree.getParameter("NAME");
        this.statusInfo = parent == null ? new RCStatusInfo(packageTree, null) : new RCStatusInfo(packageTree, parent.getStatusInfo());
        this.statusInfoInexactMatch = new RCStatusInfo(this.statusInfo.getComponentName() + ".*", this.statusInfo.getStatus(), this.statusInfo.getPriority(), this.statusInfo.getReason(), this.statusInfo.getAuthUsers());
        StructureTree[] classTrees = packageTree.getChildren("CLASS");
        ArrayList<RCClass> classes = new ArrayList<RCClass>();
        int i = 0;
        while (i < classTrees.length) {
            classes.add(new RCClass(classTrees[i], this.statusInfo));
            ++i;
        }
        this.classes = classes.toArray(new RCClass[0]);
        StructureTree[] pkgTrees = packageTree.getChildren("PACKAGE");
        ArrayList<RCPackage> pkgs = new ArrayList<RCPackage>();
        int i2 = 0;
        while (i2 < pkgTrees.length) {
            pkgs.add(new RCPackage(pkgTrees[i2], this));
            ++i2;
        }
        this.directSubPackages = pkgs.toArray(new RCPackage[0]);
    }

    public RCPackage(String name, RCPackage[] directSubPackages, RCClass[] classes, RCStatusInfo statusInfo) {
        this.name = name;
        this.directSubPackages = directSubPackages;
        this.classes = classes;
        this.statusInfo = statusInfo;
        this.statusInfoInexactMatch = new RCStatusInfo(statusInfo.getComponentName() + ".*", statusInfo.getStatus(), statusInfo.getPriority(), statusInfo.getReason(), statusInfo.getAuthUsers());
    }

    public RCClass[] getClasses() {
        return this.classes;
    }

    public RCPackage[] getDirectSubPackages() {
        return this.directSubPackages;
    }

    public String getName() {
        return this.name;
    }

    public RCStatusInfo getStatusInfo() {
        return this.statusInfo;
    }

    public RCStatusInfo getStatusInfo(String caller, String[] callee, int curIdx) {
        Iterator iter = this.statusInfo.getAuthUsers().iterator();
        while (iter.hasNext()) {
            if (!caller.startsWith((String)iter.next())) continue;
            return this.statusInfo.getOKInfo();
        }
        if (callee.length - curIdx == 0) {
            return this.statusInfo;
        }
        int i = 0;
        while (i < this.directSubPackages.length) {
            if (this.directSubPackages[i].getName().equals(callee[curIdx])) {
                return this.directSubPackages[i].getStatusInfo(caller, callee, curIdx + 1);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.classes.length) {
            if (this.classes[i2].getName().equals(callee[curIdx])) {
                return this.classes[i2].getStatusInfo(caller, callee, curIdx + 1);
            }
            ++i2;
        }
        return this.statusInfoInexactMatch;
    }
}

