/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.rc;

import com.sap.tc.jtools.jlint.tests.rc.RCConstants;
import com.sap.tc.jtools.jlint.tests.rc.RCField;
import com.sap.tc.jtools.jlint.tests.rc.RCMethod;
import com.sap.tc.jtools.jlint.tests.rc.RCStatusInfo;
import com.sap.tc.jtools.util.structures.StructureTree;
import java.util.Iterator;

class RCClass
implements RCConstants {
    private RCStatusInfo statusInfo;
    private String name;
    private RCMethod[] methods;
    private RCField[] fields;
    private RCClass[] innerClasses;

    public RCClass(StructureTree classTree, RCStatusInfo parentStatus) {
        this.name = classTree.getParameter("NAME");
        this.statusInfo = new RCStatusInfo(classTree, parentStatus);
        StructureTree[] methodTrees = classTree.getChildren("METHOD");
        this.methods = new RCMethod[methodTrees.length];
        int i = 0;
        while (i < methodTrees.length) {
            this.methods[i] = new RCMethod(methodTrees[i], this);
            ++i;
        }
        StructureTree[] fieldTrees = classTree.getChildren("FIELD");
        this.fields = new RCField[fieldTrees.length];
        int i2 = 0;
        while (i2 < fieldTrees.length) {
            this.fields[i2] = new RCField(fieldTrees[i2], this);
            ++i2;
        }
        StructureTree[] innerClassTrees = classTree.getChildren("CLASS");
        this.innerClasses = new RCClass[innerClassTrees.length];
        int i3 = 0;
        while (i3 < innerClassTrees.length) {
            this.innerClasses[i3] = new RCClass(innerClassTrees[i3], this.statusInfo);
            ++i3;
        }
    }

    public RCClass(String name, RCStatusInfo statusInfo, RCMethod[] methods, RCField[] fields, RCClass[] innerClasses) {
        this.name = name;
        this.statusInfo = statusInfo;
        this.methods = methods;
        this.fields = fields;
        this.innerClasses = innerClasses;
    }

    public RCClass[] getInnerClasses() {
        return this.innerClasses;
    }

    public RCMethod[] getMethods() {
        return this.methods;
    }

    public RCField[] getFields() {
        return this.fields;
    }

    public String getName() {
        return this.name;
    }

    public RCStatusInfo getStatusInfo() {
        return this.statusInfo;
    }

    public RCStatusInfo getStatusInfo(String caller, String[] callee, int curIdx) {
        Iterator iter = this.statusInfo.getAuthUsers().iterator();
        while (iter.hasNext()) {
            if (!caller.startsWith((String)iter.next())) continue;
            return this.statusInfo.getOKInfo();
        }
        if (callee.length - curIdx == 0) {
            return this.statusInfo;
        }
        if (callee.length - curIdx > 1) {
            int i = 0;
            while (i < this.innerClasses.length) {
                if (this.innerClasses[i].getName().equals(callee[curIdx])) {
                    return this.innerClasses[i].getStatusInfo(caller, callee, curIdx + 1);
                }
                ++i;
            }
        } else if (callee[curIdx].indexOf(64) != -1) {
            int i = 0;
            while (i < this.methods.length) {
                String signature = this.methods[i].getSignature();
                String methName = this.methods[i].getName();
                if (signature == null && callee[curIdx].startsWith(methName + "@") || callee[curIdx].equals(methName + "@" + signature)) {
                    return this.methods[i].getStatusInfo(caller, callee);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.fields.length) {
                String fieldName = this.fields[i].getName();
                if (callee[curIdx].equals(fieldName)) {
                    return this.fields[i].getStatusInfo(caller, callee);
                }
                ++i;
            }
        }
        return this.statusInfo;
    }
}

