/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.performance;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IAssignment;
import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.IDoStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IForStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IName;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclarationStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IWhileStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class LoopTest
extends JomTestVisitor {
    public static final String NAME = "Instantiation in loop";
    private static final String MSG_KEY_1 = "loop.1";
    private Stack assignmentStack = new Stack();
    private Stack loopLocalVars = new Stack();

    private void addError(Position pos) {
        this.addError(MSG_KEY_1, null, pos);
    }

    private void checkAssignments() {
        List assgnmnts = (List)this.assignmentStack.peek();
        Iterator iter = assgnmnts.iterator();
        while (iter.hasNext()) {
            this.addError((Position)iter.next());
        }
    }

    public void endVisit(IDoStatement node) {
        this.checkAssignments();
        this.assignmentStack.pop();
        this.loopLocalVars.pop();
    }

    public void endVisit(IForStatement node) {
        this.checkAssignments();
        this.assignmentStack.pop();
        this.loopLocalVars.pop();
    }

    public void endVisit(IWhileStatement node) {
        this.checkAssignments();
        this.assignmentStack.pop();
        this.loopLocalVars.pop();
    }

    public String getTestName() {
        return NAME;
    }

    public boolean visit(IAssignment node) {
        if (this.assignmentStack.isEmpty() || !(node.getLeftHandSide() instanceof IName) || !(node.getRightHandSide() instanceof IClassInstanceCreation)) {
            return true;
        }
        IBinding bnd = ((IName)node.getLeftHandSide()).resolveBinding();
        if (bnd instanceof IVariableBinding) {
            IVariableBinding varBnd = (IVariableBinding)bnd;
            if (varBnd.isField()) {
                return true;
            }
            List localVars = (List)this.loopLocalVars.peek();
            Iterator iter = localVars.iterator();
            while (iter.hasNext()) {
                IVariableBinding localVarBnd = (IVariableBinding)iter.next();
                if (!localVarBnd.equals((Object)bnd)) continue;
                ((List)this.assignmentStack.peek()).add(node);
            }
        }
        return true;
    }

    public boolean visit(IDoStatement node) {
        this.assignmentStack.push(new ArrayList());
        this.loopLocalVars.push(new ArrayList());
        return true;
    }

    public boolean visit(IForStatement node) {
        this.assignmentStack.push(new ArrayList());
        this.loopLocalVars.push(new ArrayList());
        return true;
    }

    public boolean visit(IMethodInvocation node) {
        if (this.assignmentStack.isEmpty() || node.arguments().size() == 0) {
            return true;
        }
        List args = node.arguments();
        List assignments = (List)this.assignmentStack.peek();
        Iterator iterator = assignments.iterator();
        while (iterator.hasNext()) {
            IAssignment assgn = (IAssignment)iterator.next();
            Iterator argIt = args.iterator();
            while (argIt.hasNext()) {
                Object arg = argIt.next();
                if (!(arg instanceof IName) || !((IName)assgn.getLeftHandSide()).resolveBinding().equals((Object)((IName)arg).resolveBinding())) continue;
                iterator.remove();
            }
        }
        return true;
    }

    public boolean visit(IVariableDeclarationStatement node) {
        if (this.loopLocalVars.isEmpty()) {
            return true;
        }
        ((List)this.loopLocalVars.peek()).add(node.resolveBinding());
        return true;
    }

    public boolean visit(IWhileStatement node) {
        this.assignmentStack.push(new ArrayList());
        this.loopLocalVars.push(new ArrayList());
        return true;
    }
}

