/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.metrics;

import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.IForStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IIfStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ISwitchStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IWhileStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.metrics.JomMetricVisitor;
import com.sap.tc.jtools.jlint.jom.metrics.MetricInfo;
import com.sap.tc.jtools.util.collections.IntStack;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;

public class MaxNestingPerMethod
extends JomMetricVisitor {
    private static final String METRIC_NAME = "nestinglevel";
    private static final String NAME = "Max nesting level per method";
    private IntStack counterStack = new IntStack();
    private IntStack maxStack = new IntStack();

    private void decrementCounter() {
        if (this.counterStack.isEmpty()) {
            return;
        }
        this.counterStack.push(this.counterStack.pop() - 1);
    }

    public void endVisit(IBlock node) {
        this.decrementCounter();
    }

    public void endVisit(IMethodDeclaration node) {
        this.counterStack.pop();
        int maxNestingLevel = this.maxStack.pop();
        if (Modifier.isAbstract(node.getModifiers()) || node.resolveBinding().getDeclaringClass().isInterface()) {
            return;
        }
        this.addMetricValue(METRIC_NAME, maxNestingLevel, (Position)node);
    }

    protected MetricInfo[] getMetricInfos() {
        return new MetricInfo[]{new MetricInfo(METRIC_NAME, 22)};
    }

    public String getTestName() {
        return NAME;
    }

    private void incrementCounter() {
        if (this.counterStack.isEmpty() || this.maxStack.isEmpty()) {
            return;
        }
        int maxLevel = this.maxStack.pop();
        int currentLevel = this.counterStack.pop() + 1;
        this.counterStack.push(currentLevel);
        this.maxStack.push(Math.max(maxLevel, currentLevel));
    }

    public boolean visit(IBlock node) {
        this.incrementCounter();
        return true;
    }

    public boolean visit(IForStatement node) {
        if (node.getBody() instanceof IBlock) {
            return true;
        }
        this.incrementCounter();
        this.decrementCounter();
        return true;
    }

    public boolean visit(IIfStatement node) {
        IStatement elseStmt;
        if (!(node.getThenStatement() instanceof IBlock)) {
            this.incrementCounter();
            this.decrementCounter();
        }
        if ((elseStmt = node.getElseStatement()) != null && !(elseStmt instanceof IBlock)) {
            this.incrementCounter();
            this.decrementCounter();
        }
        return true;
    }

    public boolean visit(IMethodDeclaration node) {
        this.counterStack.push(-1);
        this.maxStack.push(-1);
        return true;
    }

    public boolean visit(ISwitchStatement node) {
        List stmts = node.statements();
        Iterator iter = stmts.iterator();
        while (iter.hasNext()) {
            if (iter.next() instanceof IBlock) continue;
            this.incrementCounter();
            this.decrementCounter();
        }
        return true;
    }

    public boolean visit(IWhileStatement node) {
        if (node.getBody() instanceof IBlock) {
            return true;
        }
        this.incrementCounter();
        this.decrementCounter();
        return true;
    }
}

