/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.metrics;

import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.metrics.JomMetricVisitor;
import com.sap.tc.jtools.jlint.jom.metrics.MetricInfo;

public class HierarchyDepth
extends JomMetricVisitor {
    private static final String NAME = "Inheritance Hierarchy Depth";
    private static final String METRIC_NAME = "hierarchydepth";

    public String getTestName() {
        return NAME;
    }

    protected MetricInfo[] getMetricInfos() {
        return new MetricInfo[]{new MetricInfo(METRIC_NAME, 22)};
    }

    public boolean visit(ITypeDeclaration node) {
        int depth = this.getDepth(node.resolveBinding(), 0);
        this.addMetricValue(METRIC_NAME, depth, (Position)node);
        return true;
    }

    private int getDepth(IReferenceTypeBinding bnd, int counter) {
        if (bnd.getSuperclass() != null) {
            return this.getDepth(bnd.getSuperclass(), ++counter);
        }
        return counter;
    }
}

