/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.metrics;

import com.sap.tc.jtools.jlint.jom.interfaces.ICatchClause;
import com.sap.tc.jtools.jlint.jom.interfaces.IForStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IIfStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.ISwitchCase;
import com.sap.tc.jtools.jlint.jom.interfaces.IThrowStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IWhileStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.metrics.JomMetricVisitor;
import com.sap.tc.jtools.jlint.jom.metrics.MetricInfo;
import com.sap.tc.jtools.util.collections.IntStack;
import java.lang.reflect.Modifier;

public class CyclomaticComplexity
extends JomMetricVisitor {
    public static final String TEST_NAME = "Cyclomatic Complexity Metric";
    private static final String METRIC_NAME = "complexity";
    private IntStack complexityCounterStack = new IntStack();

    protected final MetricInfo[] getMetricInfos() {
        return new MetricInfo[]{new MetricInfo(METRIC_NAME, 22)};
    }

    public final String getTestName() {
        return TEST_NAME;
    }

    public final void endVisit(IMethodDeclaration meth) {
        if (this.complexityCounterStack.isEmpty()) {
            return;
        }
        int complexity = this.complexityCounterStack.pop();
        int modifiers = meth.getModifiers();
        if (!Modifier.isAbstract(modifiers) && !Modifier.isNative(modifiers)) {
            this.addMetricValue(METRIC_NAME, complexity, (Position)meth);
        }
    }

    public final boolean visit(ICatchClause node) {
        this.incrementCounter();
        return true;
    }

    private void incrementCounter() {
        if (this.complexityCounterStack.isEmpty()) {
            return;
        }
        this.complexityCounterStack.push(this.complexityCounterStack.pop() + 1);
    }

    public final boolean visit(IForStatement node) {
        this.incrementCounter();
        return true;
    }

    public final boolean visit(IIfStatement node) {
        this.incrementCounter();
        return true;
    }

    public final boolean visit(IMethodDeclaration node) {
        this.complexityCounterStack.push(1);
        return true;
    }

    public final boolean visit(ISwitchCase node) {
        this.incrementCounter();
        return true;
    }

    public final boolean visit(IThrowStatement node) {
        this.incrementCounter();
        return true;
    }

    public final boolean visit(IWhileStatement node) {
        this.incrementCounter();
        return true;
    }

    public final boolean visit(ITypeDeclaration node) {
        return !node.isInterface() && !node.isLocalTypeDeclaration();
    }
}

