/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.logging;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.ciwrappers2_1.FieldAccess;
import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.ICatchClause;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpressionStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldAccess;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IThrowStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.util.InheritanceTool;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Stack;

public class LoggingTracingSeverityCheck
extends JomTestVisitor {
    private static final String NAME = "Logging Severities Check";
    private static final String FATAL_SEVERITY_NAME = "FATAL";
    private static final String ERROR_SEVERITY_NAME = "ERROR";
    private static final String WARNING_SEVERITY_NAME = "WARNING";
    private static final String INFO_SEVERITY_NAME = "INFO";
    private static final String PATH_SEVERITY_NAME = "PATH";
    private static final String DEBUG_SEVERITY_NAME = "DEBUG";
    private static final String LOCATION = "com.sap.tc.logging.Location";
    private static final String CATEGORY = "com.sap.tc.logging.Category";
    private static final String MSG_KEY_1 = "LoggingCheck.1";
    private static final String MSG_KEY_2 = "LoggingCheck.2";
    private static final String MSG_KEY_3 = "LoggingCheck.3";
    private static final String MSG_KEY_4 = "LoggingCheck.4";
    private static final short STATEMENT_DIST = (short)2;
    private static final short DEFAULT_POS = (short)-1;
    private Stack m_blockInfoStack = new Stack();
    private BlockInfo m_blockInfo = null;
    private boolean m_inCatchClause = false;

    public String getTestName() {
        return NAME;
    }

    private void scrutinizeMethodInvocation(IMethodInvocation node) {
        String propVal = node.getName();
        if (this.isLogOrTraceMethodWithoutSeverity(node.getName())) {
            this.checkSeverity(node);
        }
        if (this.isTraceMethodWithSeverity(node.getName())) {
            this.checkLogControllerBinding(node, true);
        }
        if (this.isLogMethodWithSeverity(node.getName())) {
            this.checkLogControllerBinding(node, false);
        }
    }

    private void checkLogControllerBinding(IMethodInvocation node, boolean isTrace) {
        Properties props = new Properties();
        String nodeName = node.getName();
        ((Hashtable)props).put("methodName", nodeName);
        IMethodBinding methBnd = node.resolveMethodBinding();
        IReferenceTypeBinding declClass = methBnd.getDeclaringClass();
        if (InheritanceTool.bndExtends((IReferenceTypeBinding)declClass, (String)LOCATION) && !isTrace) {
            if (this.isErrorTraceMethodCall(node)) {
                this.m_blockInfo.m_errorTraceDetected = true;
                this.m_blockInfo.m_traceInvocation = node;
                this.m_blockInfo.m_errorTracePos = node.getStartPosition();
            } else {
                this.addError(MSG_KEY_3, props, (Position)node);
            }
        }
        if (InheritanceTool.bndExtends((IReferenceTypeBinding)declClass, (String)CATEGORY) && isTrace) {
            this.addError(MSG_KEY_4, props, (Position)node);
        }
    }

    private boolean isErrorTraceMethodCall(IMethodInvocation node) {
        return node.getName().equals("error") || node.getName().equals("errorT");
    }

    private boolean isLogOrTraceMethodWithoutSeverity(String methodName) {
        return methodName.equals("logT") || methodName.equals("log") || methodName.equals("traceThrowableT") || methodName.equals("logThrowableT") || methodName.equals("logThrowable");
    }

    private boolean isTraceMethodWithSeverity(String methodName) {
        return methodName.equals("path") || methodName.equals("pathT") || methodName.equals("debug") || methodName.equals("debugT");
    }

    private boolean isLogMethodWithSeverity(String methodName) {
        return methodName.equals("fatal") || methodName.equals("fatalT") || methodName.equals("errorT") || methodName.equals("error") || methodName.equals("warning") || methodName.equals("warningT");
    }

    private void checkSeverity(IMethodInvocation node) {
        IMethodBinding methBnd = node.resolveMethodBinding();
        IReferenceTypeBinding declClass = methBnd.getDeclaringClass();
        if (InheritanceTool.bndExtends((IReferenceTypeBinding)declClass, (String)LOCATION)) {
            this.checkTraceWriting(node);
        }
        if (InheritanceTool.bndExtends((IReferenceTypeBinding)declClass, (String)CATEGORY)) {
            this.checkLogWriting(node);
        }
    }

    private void printErrorString(String key, Properties p, String propName, String propVal, IMethodInvocation node) {
        p.setProperty(propName, propVal);
        this.addError(key, p, (Position)node);
    }

    private void checkTraceWriting(IMethodInvocation node) {
        Object o;
        Properties msgProps = new Properties();
        List paras = node.arguments();
        if (!paras.isEmpty() && (o = paras.get(0)) instanceof IFieldAccess) {
            FieldAccess fa = (FieldAccess)o;
            String val = null;
            if (fa != null) {
                val = fa.getName();
                if (val.equals(FATAL_SEVERITY_NAME)) {
                    this.printErrorString(MSG_KEY_1, msgProps, "severity", FATAL_SEVERITY_NAME, node);
                }
                if (val.equals(ERROR_SEVERITY_NAME)) {
                    this.m_blockInfo.m_errorTraceDetected = true;
                    this.m_blockInfo.m_traceInvocation = node;
                    this.m_blockInfo.m_errorTracePos = node.getStartPosition();
                }
                if (val.equals(WARNING_SEVERITY_NAME)) {
                    this.printErrorString(MSG_KEY_1, msgProps, "severity", WARNING_SEVERITY_NAME, node);
                }
            }
        }
    }

    private void checkLogWriting(IMethodInvocation node) {
        Object o;
        Properties msgProps = new Properties();
        List paras = node.arguments();
        if (!paras.isEmpty() && (o = paras.get(0)) instanceof IFieldAccess) {
            FieldAccess fa = (FieldAccess)o;
            String val = null;
            if (fa != null) {
                val = fa.getName();
                if (val.equals(DEBUG_SEVERITY_NAME)) {
                    this.printErrorString(MSG_KEY_2, msgProps, "severity", DEBUG_SEVERITY_NAME, node);
                }
                if (val.equals(PATH_SEVERITY_NAME)) {
                    this.printErrorString(MSG_KEY_2, msgProps, "severity", PATH_SEVERITY_NAME, node);
                }
            }
        }
    }

    private void visitImpl(List stmts, BlockInfo bi) {
        Iterator i = stmts.iterator();
        while (i.hasNext()) {
            IExpressionStatement exStmt;
            IExpression ex;
            Object o = i.next();
            if (!(o instanceof IStatement)) continue;
            IStatement stmt = (IStatement)o;
            if (stmt instanceof IExpressionStatement && (ex = (exStmt = (IExpressionStatement)stmt).getExpression()) instanceof IMethodInvocation) {
                IMethodInvocation methInv = (IMethodInvocation)ex;
                this.scrutinizeMethodInvocation(methInv);
            }
            if (!(stmt instanceof IThrowStatement)) continue;
            this.m_blockInfo.m_throwPos = ((IThrowStatement)stmt).getStartPosition();
            this.m_blockInfo.m_existCorrespondingThrow = true;
        }
    }

    private void endVisitImpl() {
        this.m_blockInfo = (BlockInfo)this.m_blockInfoStack.pop();
        if (this.m_blockInfo.m_errorTraceDetected) {
            int errorTraceLine;
            int throwLine;
            Properties p = new Properties();
            if (!this.m_blockInfo.m_existCorrespondingThrow && !this.m_inCatchClause) {
                this.printErrorString(MSG_KEY_1, p, "severity", ERROR_SEVERITY_NAME, this.m_blockInfo.m_traceInvocation);
            } else if (this.m_blockInfo.m_existCorrespondingThrow && !this.m_inCatchClause && Math.abs((throwLine = this.currentCompilationUnit.lineNumber(this.m_blockInfo.m_throwPos)) - (errorTraceLine = this.currentCompilationUnit.lineNumber(this.m_blockInfo.m_errorTracePos))) > STATEMENT_DIST) {
                this.printErrorString(MSG_KEY_1, p, "severity", ERROR_SEVERITY_NAME, this.m_blockInfo.m_traceInvocation);
            }
        }
    }

    public boolean visit(IBlock node) {
        this.m_blockInfo = new BlockInfo();
        List stmts = node.statements();
        this.visitImpl(stmts, this.m_blockInfo);
        this.m_blockInfoStack.push(this.m_blockInfo);
        return true;
    }

    public void endVisit(IBlock node) {
        this.endVisitImpl();
    }

    public void endVisit(ICatchClause node) {
        this.m_inCatchClause = false;
    }

    public boolean visit(ICatchClause node) {
        this.m_inCatchClause = true;
        return true;
    }

    static /* synthetic */ short access$000() {
        return DEFAULT_POS;
    }

    private class BlockInfo {
        private boolean m_errorTraceDetected = false;
        private boolean m_existCorrespondingThrow = false;
        private int m_errorTracePos = LoggingTracingSeverityCheck.access$000();
        private int m_throwPos = LoggingTracingSeverityCheck.access$000();
        private IMethodInvocation m_traceInvocation = null;

        BlockInfo() {
        }
    }
}

