/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.logging;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.util.InheritanceTool;
import java.util.Properties;

public class LoggingConfiguring
extends JomTestVisitor {
    private static final String LOG_CONTROLLER_CLASS = "com.sap.tc.logging.LogController";
    private static final String METHOD_NAME = "method";
    private static final String MSG_KEY_1 = "logconfig.1";
    private static final String[] LOG_CONTROLLER_METHODS = new String[]{"addFilter", "addLocalLog", "addLog", "addPrivateLog", "removeFilter", "removeFilters", "removeLog", "removeLogs", "setEffectiveSeverity", "setMaximumSeverity", "setMinimumSeverity", "setName", "setResourceBundleName"};
    private static final String NAME = "Configuring Logging";

    public String getTestName() {
        return NAME;
    }

    public boolean visit(IMethodInvocation node) {
        IMethodBinding methodBinding = node.resolveMethodBinding();
        IReferenceTypeBinding typeBinding = methodBinding.getDeclaringClass();
        String methodName = methodBinding.getName();
        Properties properties = new Properties();
        properties.setProperty(METHOD_NAME, methodName);
        if (this.checkLogControllerMethods(typeBinding, methodName)) {
            this.addError(MSG_KEY_1, properties, (Position)node);
        }
        return true;
    }

    private boolean checkLogControllerMethods(IReferenceTypeBinding typeBinding, String methodName) {
        if (InheritanceTool.bndExtends((IReferenceTypeBinding)typeBinding, (String)LOG_CONTROLLER_CLASS)) {
            int i = 0;
            while (i < LOG_CONTROLLER_METHODS.length) {
                if (methodName.equals(LOG_CONTROLLER_METHODS[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

