/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.logging;

import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldAccess;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleName;
import com.sap.tc.jtools.jlint.jom.interfaces.IStringLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.metrics.JomMetricVisitor;
import com.sap.tc.jtools.jlint.jom.metrics.MetricInfo;
import com.sap.tc.jtools.jlint.jom.util.InheritanceTool;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.FileReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class LoggingAndTracingTest
extends JomMetricVisitor {
    private static final String PAR_LOG_METHOD_INFO = "LOG_METHOD_INFO";
    private static final String NAME = "Logging and Tracing Test";
    private static final String LOG_OR_TRACE_MSG_METRIC = "log or trace method call";
    private static final String MSG_KEY_1 = "logging.1";
    private static final String MSG_KEY_2 = "logging.2";
    private static final String MSG_KEY_3 = "logging.3";
    private static final String MSG_KEY_4 = "logging.4";
    private static final String MSG_PAR_CAT_USED = "USED_CATEGORY";
    private static final String MSG_PAR_LOG_MSG_USED = "USED_LOG_MESSAGE";
    private static final String MSG_PAR_LOG_CLASS = "LOG_CLASS";
    private static final String MSG_PAR_LOG_METHOD = "LOG_METHOD";
    private static final String MSG_PAR_FORMATTER_NAME = "FORMATTER_NAME";
    private static final String LOG = "com.sap.tc.logging.Log";
    private static final String CATEGORY = "com.sap.tc.logging.Category";
    private static final String FORMATTER = "com.sap.tc.logging.Formatter";
    private static final String GET_CATEGORY = "getCategory";
    private static LogMethodInfo[] logMethods;
    private static final String PAR_CHECK_TRACE_MSGS = "CHECK_FOR_TRACE_MSGS";
    private static final String PAR_IGNORE_UNKNOWN_MSGS = "IGNORE_STATICALLY_UNKNOWN_MSGS";
    private boolean checkForTraceMsgs = true;
    private boolean ignoreUnknownMsgs = true;

    public String getTestName() {
        return NAME;
    }

    protected MetricInfo[] getMetricInfos() {
        return new MetricInfo[]{new MetricInfo(LOG_OR_TRACE_MSG_METRIC, 1)};
    }

    public boolean visit(IMethodInvocation node) {
        IReferenceTypeBinding declClass;
        IMethodBinding methBnd = node.resolveMethodBinding();
        LogMethodInfo logMethod = LoggingAndTracingTest.getLogOrTraceMethod(methBnd);
        if (logMethod != null) {
            this.addMetricValue(LOG_OR_TRACE_MSG_METRIC, 1.0f, (Position)node);
            this.checkCall(logMethod, node);
        }
        if (InheritanceTool.bndExtends((IReferenceTypeBinding)(declClass = methBnd.getDeclaringClass()), (String)CATEGORY)) {
            this.checkCategoryCall(methBnd, node);
        }
        return true;
    }

    private void checkCall(LogMethodInfo logMethod, IMethodInvocation invocation) {
        String msg;
        String cat = this.getCategory(logMethod, invocation);
        if (cat != null) {
            Properties p = new Properties();
            p.setProperty(MSG_PAR_CAT_USED, cat);
            this.addError(MSG_KEY_1, p, (Position)invocation);
        }
        if ((msg = this.getLogMsg(invocation, logMethod)) != null) {
            Properties p = new Properties();
            p.setProperty(MSG_PAR_LOG_MSG_USED, msg);
            p.setProperty(MSG_PAR_LOG_CLASS, logMethod.getClasz());
            p.setProperty(MSG_PAR_LOG_METHOD, logMethod.getName() + "@" + logMethod.getSignature());
            if (logMethod.getType().equals("log")) {
                this.addError(MSG_KEY_3, p, (Position)invocation);
            } else if (this.checkForTraceMsgs) {
                this.addError(MSG_KEY_4, p, (Position)invocation);
            }
        }
    }

    private String getCategory(LogMethodInfo logMethod, IMethodInvocation invocation) {
        return this.getParameterValue(invocation, logMethod.getCategory());
    }

    private String getLogMsg(IMethodInvocation invocation, LogMethodInfo logMethod) {
        String msg = logMethod.getText();
        return this.getParameterValue(invocation, msg);
    }

    private String getParameterValue(IMethodInvocation mi, String code) {
        if (code == null) {
            return null;
        }
        if (!code.startsWith("$")) {
            return code;
        }
        String msgPosition = code.substring(1);
        try {
            int msgIndex = Integer.parseInt(msgPosition);
            List args = mi.arguments();
            return this.getString((IExpression)args.get(msgIndex));
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getString(IExpression expr) {
        IFieldAccess name;
        IVariableBinding binding;
        if (expr instanceof IStringLiteral) {
            return ((IStringLiteral)expr).getLiteralValue();
        }
        String result = null;
        if (expr instanceof ISimpleName) {
            ISimpleName name2 = (ISimpleName)expr;
            IBinding binding2 = name2.resolveBinding();
            if (binding2 instanceof IVariableBinding) {
                IVariableBinding vb = (IVariableBinding)binding2;
                result = vb.getValue();
            }
        } else if (expr instanceof IFieldAccess && (binding = (name = (IFieldAccess)expr).resolveBinding()) instanceof IVariableBinding) {
            IVariableBinding vb = binding;
            result = vb.getValue();
        }
        if (!this.ignoreUnknownMsgs && result == null) {
            return "<statically unknown>";
        }
        return result;
    }

    private static LogMethodInfo getLogOrTraceMethod(IMethodBinding methBnd) {
        String methName = methBnd.getName();
        IReferenceTypeBinding declClass = methBnd.getDeclaringClass();
        ITypeBinding[] parTypes = methBnd.getParameterTypes();
        String methSig = "";
        int i = 0;
        while (i < parTypes.length) {
            methSig = methSig + parTypes[i].getName() + ";";
            ++i;
        }
        int i2 = 0;
        while (i2 < logMethods.length) {
            String signature;
            String name;
            String cls = logMethods[i2].getClasz();
            if ((InheritanceTool.bndImplements((IReferenceTypeBinding)declClass, (String)cls) || InheritanceTool.bndExtends((IReferenceTypeBinding)declClass, (String)cls)) && methName.equals(name = logMethods[i2].getName()) && (signature = logMethods[i2].getSignature()).equals(methSig)) {
                return logMethods[i2];
            }
            ++i2;
        }
        return null;
    }

    public boolean visit(IClassInstanceCreation node) {
        IMethodBinding constrBnd = node.resolveConstructorBinding();
        if (InheritanceTool.bndExtends((IReferenceTypeBinding)constrBnd.getDeclaringClass(), (String)LOG)) {
            List args = node.arguments();
            Iterator iter = args.iterator();
            while (iter.hasNext()) {
                ITypeBinding argBnd = ((IExpression)iter.next()).resolveTypeBinding();
                if (!(argBnd instanceof IReferenceTypeBinding) || !InheritanceTool.bndExtends((IReferenceTypeBinding)((IReferenceTypeBinding)argBnd), (String)FORMATTER)) continue;
                Properties p = new Properties();
                p.setProperty(MSG_PAR_FORMATTER_NAME, ((IReferenceTypeBinding)argBnd).getName());
                this.addError(MSG_KEY_2, p, (Position)node);
            }
        }
        return true;
    }

    public boolean visit(ICompilationUnit node) {
        this.addMetricValue(LOG_OR_TRACE_MSG_METRIC, 0.0f, (Position)node);
        return true;
    }

    public void setParameters(ParameterInterface[] parameters, TestObject testObject) {
        super.setParameters(parameters, testObject);
        this.checkForTraceMsgs = (Boolean)this.getInputParameter(PAR_CHECK_TRACE_MSGS);
        this.ignoreUnknownMsgs = (Boolean)this.getInputParameter(PAR_IGNORE_UNKNOWN_MSGS);
        String logMethodFile = (String)((Object)this.getInputParameter(PAR_LOG_METHOD_INFO));
        try {
            StructureTree tree = XMLTool.parseReader((Reader)new FileReader(logMethodFile));
            StructureTree[] children = tree.getChildren();
            logMethods = new LogMethodInfo[children.length];
            int i = 0;
            while (i < children.length) {
                LoggingAndTracingTest.logMethods[i] = new LogMethodInfo(children[i]);
                ++i;
            }
        }
        catch (Exception e) {
            this.logException(e);
            logMethods = new LogMethodInfo[0];
        }
    }

    private void checkCategoryCall(IMethodBinding methBnd, IMethodInvocation invocation) {
        String cat;
        List args = invocation.arguments();
        if (GET_CATEGORY.equals(methBnd.getName()) && args.size() == 1 && (cat = this.getParameterValue(invocation, "$0")) != null) {
            Properties p = new Properties();
            p.setProperty(MSG_PAR_CAT_USED, cat);
            this.addError(MSG_KEY_1, p, (Position)invocation);
        }
    }

    private class LogMethodInfo {
        private static final String LOG_METHOD = "log-method";
        private static final String TRACE_METHOD = "trace-method";
        public static final String LOG_TYPE = "log";
        public static final String TRACE_TYPE = "trace";
        private String type;
        private String clasz;
        private String name;
        private String signature;
        private String category;
        private String location;
        private String text;

        public LogMethodInfo(StructureTree tree) {
            String tag = tree.getTag();
            if (tag.equals(LOG_METHOD)) {
                this.type = LOG_TYPE;
            } else if (tag.equals(TRACE_METHOD)) {
                this.type = TRACE_TYPE;
            }
            this.clasz = tree.getParameter("class");
            this.name = tree.getParameter("name");
            this.signature = tree.getParameter("signature");
            this.category = tree.getParameter("category");
            this.location = tree.getParameter("location");
            this.text = tree.getParameter("text");
        }

        public String getCategory() {
            return this.category;
        }

        public String getClasz() {
            return this.clasz;
        }

        public String getLocation() {
            return this.location;
        }

        public String getName() {
            return this.name;
        }

        public String getSignature() {
            return this.signature;
        }

        public String getText() {
            return this.text;
        }

        public String getType() {
            return this.type;
        }
    }
}

