/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.language;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IBreakStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit;
import com.sap.tc.jtools.jlint.jom.interfaces.IContinueStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IReturnStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ISwitchCase;
import com.sap.tc.jtools.jlint.jom.interfaces.ISwitchStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IThrowStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.util.collections.BooleanStack;
import com.sap.tc.jtools.util.collections.IntStack;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;

public class SwitchTest
extends JomTestVisitor {
    public static String NAME = "Switch Test";
    public static String PAR_MAX_CASE_NUMBER = "MAX_CASE_NUMBER";
    private static final String MSG_KEY_1 = "switch.1";
    private static final String MSG_KEY_2 = "switch.2";
    private static final String MSG_KEY_3 = "switch.3";
    private static final String MSG_KEY_4 = "switch.4";
    private BooleanStack switchStack = new BooleanStack();
    private IntStack caseCounterStack = new IntStack(20);
    private Stack caseStack = new Stack();
    private int maxCaseNumber;

    public String getTestName() {
        return NAME;
    }

    public boolean visit(ISwitchCase node) {
        this.caseCounterStack.push(this.caseCounterStack.pop() + 1);
        Stack csStack = (Stack)this.caseStack.peek();
        HashMap<ISwitchCase, Boolean> fallThruMap = new HashMap<ISwitchCase, Boolean>(1);
        fallThruMap.put(node, Boolean.TRUE);
        csStack.push(fallThruMap);
        if (node.isDefault()) {
            this.switchStack.pop();
            this.switchStack.push(true);
        } else if (this.switchStack.peek()) {
            this.addError(MSG_KEY_3, null, (Position)node);
        }
        return true;
    }

    public void endVisit(ISwitchStatement node) {
        int caseCount;
        if (!this.switchStack.peek()) {
            this.addError(MSG_KEY_1, null, (Position)node);
        }
        if ((caseCount = this.caseCounterStack.pop()) > this.maxCaseNumber) {
            Properties p = new Properties();
            p.setProperty(PAR_MAX_CASE_NUMBER, String.valueOf(this.maxCaseNumber));
            this.addError(MSG_KEY_4, p, (Position)node);
        }
        this.checkCases(node);
        this.switchStack.pop();
        this.caseStack.pop();
    }

    private void checkCases(ISwitchStatement switchStmt) {
        Stack csStack = (Stack)this.caseStack.peek();
        while (!csStack.isEmpty()) {
            Map fallThruMap = (Map)csStack.pop();
            Set deliberateFallThrus = this.getDeliberateFallThrus(switchStmt);
            Set entries = fallThruMap.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                ISwitchCase caze = (ISwitchCase)entry.getKey();
                Boolean fallThru = (Boolean)entry.getValue();
                if (!fallThru.booleanValue() || deliberateFallThrus.contains(caze)) continue;
                this.addFallThroughError((Position)caze);
            }
        }
    }

    private Set getDeliberateFallThrus(ISwitchStatement switchStmt) {
        HashSet<Object> out = new HashSet<Object>();
        List stmts = switchStmt.statements();
        IStatement lastStmt = null;
        ISwitchCase lastSwitchCase = null;
        Iterator iter = stmts.iterator();
        while (iter.hasNext()) {
            IStatement stmt = (IStatement)iter.next();
            if (stmt instanceof ISwitchCase) {
                lastSwitchCase = (ISwitchCase)stmt;
            }
            if (lastStmt != null && lastStmt instanceof ISwitchCase && stmt instanceof ISwitchCase) {
                out.add(lastStmt);
            }
            lastStmt = stmt;
        }
        if (lastSwitchCase != null) {
            out.add(lastSwitchCase);
        }
        return out;
    }

    public boolean visit(ISwitchStatement node) {
        this.switchStack.push(false);
        this.caseStack.push(new Stack());
        this.caseCounterStack.push(0);
        return true;
    }

    private void addFallThroughError(Position pos) {
        this.addError(MSG_KEY_2, null, pos);
    }

    public boolean visit(IBreakStatement node) {
        if (this.caseStack.isEmpty()) {
            return true;
        }
        this.markCaseNoFallThru();
        return true;
    }

    private void markCaseNoFallThru() {
        Stack csStack = (Stack)this.caseStack.peek();
        Map fallThruMap = (Map)csStack.peek();
        Set entries = fallThruMap.entrySet();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            fallThruMap.put(entry.getKey(), Boolean.FALSE);
        }
    }

    public boolean visit(IContinueStatement node) {
        if (this.caseStack.isEmpty()) {
            return true;
        }
        this.markCaseNoFallThru();
        return true;
    }

    public boolean visit(IReturnStatement node) {
        if (this.caseStack.isEmpty()) {
            return true;
        }
        this.markCaseNoFallThru();
        return true;
    }

    public boolean visit(IThrowStatement node) {
        if (this.caseStack.isEmpty()) {
            return true;
        }
        this.markCaseNoFallThru();
        return true;
    }

    public void setParameters(ParameterInterface[] parameters, TestObject testObject) {
        super.setParameters(parameters, testObject);
        this.maxCaseNumber = (Integer)this.getInputParameter(PAR_MAX_CASE_NUMBER);
    }

    public boolean visit(ICompilationUnit node) {
        this.switchStack.clear();
        this.caseCounterStack.clear();
        this.caseStack.clear();
        return true;
    }
}

