/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.language;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleType;
import com.sap.tc.jtools.jlint.jom.interfaces.ISuperMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class FinalizationTest
extends JomTestVisitor {
    private static final String NAME = "Finalization Test";
    private static final String MSG_KEY_1 = "finalize.1";
    private static final String MSG_KEY_2 = "finalize.2";
    private static final String MSG_KEY_3 = "finalize.3";
    private static final String FINALIZE_METHOD = "finalize";
    private Stack finalizeMethods = new Stack();

    public String getTestName() {
        return NAME;
    }

    public boolean visit(IMethodDeclaration node) {
        this.checkFinalize(node);
        return true;
    }

    private void checkFinalize(IMethodDeclaration node) {
        if (FINALIZE_METHOD.equals(node.getName()) && node.getReturnType().isSimpleType() && "void".equals(((ISimpleType)node.getReturnType()).getName()[0]) && node.parameters().size() == 0) {
            this.addError(MSG_KEY_2, null, (Position)node);
            if (!Modifier.isProtected(node.resolveBinding().getModifiers())) {
                this.addError(MSG_KEY_3, null, (Position)node);
            }
            HashMap<IMethodDeclaration, Boolean> superFinCalled = new HashMap<IMethodDeclaration, Boolean>();
            superFinCalled.put(node, Boolean.FALSE);
            this.finalizeMethods.push(superFinCalled);
        }
    }

    public boolean visit(ISuperMethodInvocation node) {
        if (this.finalizeMethods.isEmpty()) {
            return true;
        }
        if (FINALIZE_METHOD.equals(node.getName()) && node.arguments().size() == 0) {
            Map superFinCalled = (Map)this.finalizeMethods.peek();
            Iterator iter = superFinCalled.keySet().iterator();
            IMethodDeclaration finalizeMeth = (IMethodDeclaration)iter.next();
            superFinCalled.put(finalizeMeth, Boolean.TRUE);
        }
        return true;
    }

    public void endVisit(IMethodDeclaration node) {
        if (this.finalizeMethods.isEmpty()) {
            return;
        }
        Map superFinCalled = (Map)this.finalizeMethods.peek();
        Iterator iter = superFinCalled.keySet().iterator();
        IMethodDeclaration finalizeMeth = (IMethodDeclaration)iter.next();
        if (finalizeMeth == node) {
            Boolean ok = (Boolean)superFinCalled.get(finalizeMeth);
            if (!ok.booleanValue()) {
                this.addFinalizeError((Position)node);
            }
            this.finalizeMethods.pop();
        }
    }

    private void addFinalizeError(Position pos) {
        this.addError(MSG_KEY_1, null, pos);
    }
}

