/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.language;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.IInitializer;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IReturnStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ITryStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public class FinalBlocks
extends JomTestVisitor {
    private static final String NAME = "FinalBlocks";
    public static final String ABORT_FINALLY_BLOCK = "finalblocks.1";
    private Set finallyBlocks = new HashSet();
    private Stack finallyBlockStack = new Stack();

    public String getTestName() {
        return NAME;
    }

    public void endVisit(IBlock node) {
        if (this.finallyBlocks.contains(node)) {
            this.finallyBlockStack.pop();
        }
    }

    public boolean visit(IBlock node) {
        if (this.finallyBlocks.contains(node)) {
            this.finallyBlockStack.push(node);
        }
        return true;
    }

    public boolean visit(IReturnStatement node) {
        this.checkIfInFinally((Position)node);
        return true;
    }

    public boolean visit(ITryStatement node) {
        IBlock fnlBlock = node.getFinally();
        if (fnlBlock != null) {
            this.finallyBlocks.add(fnlBlock);
        }
        return true;
    }

    public boolean visit(IMethodDeclaration node) {
        this.finallyBlockStack = new Stack();
        return true;
    }

    public boolean visit(IInitializer node) {
        this.finallyBlockStack = new Stack();
        return true;
    }

    private void checkIfInFinally(Position pos) {
        if (!this.finallyBlockStack.isEmpty()) {
            this.addError(ABORT_FINALLY_BLOCK, null, pos);
        }
    }
}

