/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.language;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import java.lang.reflect.Modifier;

public class EqualsHashCodeTest
extends JomTestVisitor {
    public static final String NAME = "Equals/HashCode Test";
    private static final String MSG_KEY_1 = "equals.1";
    private static final String OBJECT_FQN = "java.lang.Object";
    private static final String EQUALS_METH_NAME = "equals";
    private static final String HASHCODE_METH_NAME = "hashCode";

    public String getTestName() {
        return NAME;
    }

    private boolean isHashCodeMethod(IMethodDeclaration node) {
        return HASHCODE_METH_NAME.equals(node.getName()) && node.parameters().size() == 0 && Modifier.isPublic(node.getModifiers());
    }

    private boolean isEqualsMethod(IMethodDeclaration node) {
        return EQUALS_METH_NAME.equals(node.getName()) && node.parameters().size() == 1 && OBJECT_FQN.equals(node.parameters().toArray(new IVariableDeclaration[1])[0].resolveBinding().getType().getName()) && Modifier.isPublic(node.getModifiers());
    }

    public boolean visit(ITypeDeclaration node) {
        if (node.isInterface() || Modifier.isAbstract(node.getModifiers())) {
            return true;
        }
        IMethodDeclaration[] methods = node.getMethods();
        boolean overridesEquals = false;
        IMethodDeclaration equalsPosition = null;
        int i = 0;
        while (i < methods.length && !overridesEquals) {
            if (this.isEqualsMethod(methods[i])) {
                overridesEquals = true;
                equalsPosition = methods[i];
            }
            ++i;
        }
        if (!overridesEquals) {
            return true;
        }
        boolean overridesHashCode = false;
        int i2 = 0;
        while (i2 < methods.length && !overridesHashCode) {
            if (this.isHashCodeMethod(methods[i2])) {
                overridesHashCode = true;
            }
            ++i2;
        }
        if (!overridesHashCode) {
            this.addError(MSG_KEY_1, null, (Position)equalsPosition);
        }
        return true;
    }
}

