/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.language;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.util.InheritanceTool;
import java.lang.reflect.Modifier;

public class CloneableTest
extends JomTestVisitor {
    public static final String NAME = "Cloneable Test";
    private static final String MSG_KEY_1 = "clone.1";
    public static final String CLONEABLE_INTF_NAME = "java.lang.Cloneable";
    public static final String CLONE_METH_NAME = "clone";

    public String getTestName() {
        return NAME;
    }

    public boolean visit(ITypeDeclaration node) {
        if (node.isInterface() || Modifier.isAbstract(node.getModifiers())) {
            return true;
        }
        IReferenceTypeBinding bnd = node.resolveBinding();
        if (!InheritanceTool.bndImplements((IReferenceTypeBinding)bnd, (String)CLONEABLE_INTF_NAME)) {
            return true;
        }
        IFieldDeclaration[] fields = node.getFields();
        boolean hasNonPrimitiveInstanceFields = false;
        int i = 0;
        while (i < fields.length && !hasNonPrimitiveInstanceFields) {
            ITypeBinding fieldType = fields[i].getType().resolveBinding();
            hasNonPrimitiveInstanceFields = (fieldType.isReference() || fieldType.isArray()) && !Modifier.isStatic(fields[i].getModifiers());
            ++i;
        }
        IReferenceTypeBinding superClass = bnd.getSuperclass();
        if (superClass != null && !hasNonPrimitiveInstanceFields && InheritanceTool.bndImplements((IReferenceTypeBinding)superClass, (String)CLONEABLE_INTF_NAME)) {
            return true;
        }
        IMethodDeclaration[] methods = node.getMethods();
        boolean cloneMethodFound = false;
        int i2 = 0;
        while (i2 < methods.length) {
            if (CloneableTest.isCloneMethod(methods[i2])) {
                cloneMethodFound = true;
                break;
            }
            ++i2;
        }
        if (!cloneMethodFound) {
            this.addCloneMethodError((Position)node);
        }
        return true;
    }

    private void addCloneMethodError(Position pos) {
        this.addError(MSG_KEY_1, null, pos);
    }

    private static boolean isCloneMethod(IMethodDeclaration declaration) {
        return CLONE_METH_NAME.equals(declaration.getName()) && declaration.parameters().size() == 0 && Modifier.isPublic(declaration.getModifiers());
    }
}

