/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.language;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.IBreakStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IContinueStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IForStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IIfStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IReturnStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IThrowStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IWhileStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import java.util.Properties;

public class BlockTest
extends JomTestVisitor {
    public static String NAME = "Block Test";
    private static final String MSG_KEY_1 = "block.1";
    private static final String STMT_TYPE_PARAM = "STMT_TYPE";

    public String getTestName() {
        return NAME;
    }

    public boolean visit(IForStatement node) {
        this.checkIfBlock(node.getBody(), "for");
        return true;
    }

    public boolean visit(IWhileStatement node) {
        this.checkIfBlock(node.getBody(), "while");
        return true;
    }

    public boolean visit(IIfStatement node) {
        this.checkIfBlock(node.getThenStatement(), "if");
        IStatement elseStmt = node.getElseStatement();
        if (elseStmt != null && !(elseStmt instanceof IIfStatement)) {
            this.checkIfBlock(node.getElseStatement(), "else");
        }
        return true;
    }

    private void checkIfBlock(IStatement statement, String stmtType) {
        if (!(statement instanceof IBlock)) {
            if (statement instanceof IReturnStatement || statement instanceof IThrowStatement || statement instanceof IContinueStatement || statement instanceof IBreakStatement) {
                return;
            }
            this.addBlockError(stmtType, (Position)statement);
        }
    }

    private void addBlockError(String statementType, Position pos) {
        Properties p = new Properties();
        p.setProperty(STMT_TYPE_PARAM, statementType);
        this.addError(MSG_KEY_1, p, pos);
    }
}

