/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.language;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IAssignment;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpressionStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IForStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IPostfixExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IPrefixExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleName;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclarationStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;

public class AssignmentTest
extends JomTestVisitor {
    private static final String NAME = "Assignment Test";
    private static final String MSG_KEY_1 = "assign.1";
    private static final String MSG_KEY_2 = "assign.2";
    private static final String MSG_KEY_3 = "assign.3";
    private Stack forLoops = new Stack();
    private Stack methodStack = new Stack();
    private Set okAssignments = new HashSet();

    public String getTestName() {
        return NAME;
    }

    public boolean visit(IForStatement node) {
        this.forLoops.push(node);
        return true;
    }

    public void endVisit(IForStatement node) {
        this.forLoops.pop();
    }

    public boolean visit(IAssignment node) {
        IExpression leftSide = node.getLeftHandSide();
        this.checkForLoopVariable(leftSide);
        if ("boolean".equals(node.resolveTypeBinding().getName()) && !this.okAssignments.contains(node)) {
            this.addError(MSG_KEY_1, null, (Position)node);
        }
        return true;
    }

    public boolean visit(IPostfixExpression node) {
        this.checkForLoopVariable(node.getOperand());
        return true;
    }

    public boolean visit(IPrefixExpression node) {
        if ("++".equals(node.getOperator()) || "--".equals(node.getOperator())) {
            this.checkForLoopVariable(node.getOperand());
        }
        return true;
    }

    private void checkForLoopVariable(IExpression expr) {
        if (this.forLoops.isEmpty() || !(expr instanceof ISimpleName)) {
            return;
        }
        ISimpleName name = (ISimpleName)expr;
        Iterator forLoopIt = ((AbstractList)this.forLoops).iterator();
        while (forLoopIt.hasNext()) {
            IForStatement forStmt = (IForStatement)forLoopIt.next();
            int bodyPos = forStmt.getBody().getStartPosition();
            IStatement[] initializers = forStmt.getInitializers();
            int i = 0;
            while (i < initializers.length) {
                IVariableDeclarationStatement declStmt;
                IStatement o = initializers[i];
                if (o instanceof IVariableDeclarationStatement && (declStmt = (IVariableDeclarationStatement)o).resolveBinding().equals((Object)name.resolveBinding()) && expr.getStartPosition() > bodyPos) {
                    this.addAssignmentToLoopVarError((Position)expr);
                }
                ++i;
            }
        }
    }

    public boolean visit(IMethodDeclaration node) {
        this.methodStack.push(node);
        return true;
    }

    public void endVisit(IMethodDeclaration node) {
        this.methodStack.pop();
    }

    private void addAssignmentToParameterError(Position pos) {
        this.addError(MSG_KEY_2, null, pos);
    }

    private void addAssignmentToLoopVarError(Position pos) {
        this.addError(MSG_KEY_3, null, pos);
    }

    public void endVisit(IExpressionStatement node) {
        this.okAssignments.clear();
    }

    /*
     * Unable to fully structure code
     */
    public boolean visit(IExpressionStatement node) {
        expr = node.getExpression();
        if ("boolean".equals(expr.resolveTypeBinding().getName())) ** GOTO lbl8
        return true;
lbl-1000:
        // 1 sources

        {
            assgnmnt = (IAssignment)expr;
            this.okAssignments.add(expr);
            expr = assgnmnt.getRightHandSide();
lbl8:
            // 2 sources

            ** while (expr instanceof IAssignment)
        }
lbl9:
        // 1 sources

        return true;
    }
}

