/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.jdkc;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IAnonymousClassDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IAssignment;
import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ICatchClause;
import com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit;
import com.sap.tc.jtools.jlint.jom.interfaces.IConstructorInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldAccess;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IInitializer;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IQualifiedName;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleName;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleType;
import com.sap.tc.jtools.jlint.jom.interfaces.IStringLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.ITryStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeLiteral;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclarationStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.tests.rc.RCStatusInfo;
import com.sap.tc.jtools.jlint.tests.rc.RestrictedComponents;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class JomJdkcTest
extends JomTestVisitor {
    public static final String SER_VER_UID_NAME = "serialVersionUID";
    public static final String TEST_NAME = "JDK 1.3 - 1.4 compatibility test";
    public static final String PARAMETER_GRAMMAR_FILE = "GRAMMAR_FILE";
    public static final String COMPATIBILITY_URL = "http://java.sun.com/j2se/1.4/compatibility.html#source";
    public static String DEFAULT_HIGHLIGHTER = "javax.swing.text.DefaultHighlighter";
    public static String JSSE_PROPERTY = "com.sun.net.ssl.dhKeyExchangeFix";
    public static final String JAVA_LANG_OBJECT = "java.lang.Object";
    public static final String DEFAULT_PAINTER = "DefaultPainter";
    public static final String OBJECT_OUTPUT_STREAM = "java.io.ObjectOutputStream";
    public static final String OBJECT_INPUT_STREAM = "java.io.ObjectInputStream";
    public static final String SERIALIZABLE = "java.io.Serializable";
    public static final String METHOD_PUT_FIELDS = "putFields";
    public static final String METHOD_READ_FIELDS = "readFields";
    public static final String INTERFACE_APPLET_CONTEXT = "java.applet.AppletContext";
    public static final String INTERFACE_DROPTARGET_LISTENER = "java.awt.dnd.DropTargetListener";
    public static final String CLASS_SOCKET_IMPL = "java.net.SocketImpl";
    public static final String CLASS_SOCKET_ADDRESS = "java.net.SocketAddress";
    public static final String EXCEPTION_ILLEGAL_ARGUMENT = "java.lang.IllegalArgumentException";
    public static final String EXCEPTION_FILE_NOT_FOUND = "java.io.FileNotFoundException";
    public static final String EXCEPTION_RUNTIME = "java.lang.RuntimeException";
    public static final String EXCEPTION_IO = "java.io.IOException";
    public static final String EXCEPTION = "java.lang.Exception";
    public static final String THROWABLE = "java.lang.Throwable";
    public static final String CLASS_NETWORK_INTERFACE = "java.net.NetworkInterface";
    public static final String CLASS_DATAGRAM_PACKET = "java.net.DatagramPacket";
    public static final String CLASS_INET_ADDRESS = "java.net.InetAddress";
    public static final String METHOD_CONNECT = "connect";
    public static final String METHOD_JOIN_GROUP = "joinGroup";
    public static final String METHOD_LEAVE_GROUP = "leaveGroup";
    public static final String METHOD_PEEK_DATA = "peekData";
    public static final String METHOD_SEND_URGENT_DATA = "sendUrgentData";
    public static final String METHOD_DRAG_EXIT = "dragExit";
    public static final String METHOD_DROP = "drop";
    public static final String KEYWORD_ASSERT = "assert";
    private static final String JDKC_STATUS_1 = "jdkc.1";
    private static final String JDKC_STATUS_2 = "jdkc.2";
    private static final String JDKC_STATUS_3 = "jdkc.3";
    private static final String JDKC_STATUS_7_1 = "jdkc.7.1";
    private static final String JDKC_STATUS_7_2 = "jdkc.7.2";
    private static final String JDKC_STATUS_9 = "jdkc.9";
    private static final String JDKC_STATUS_11 = "jdkc.11";
    private static final String JDKC_STATUS_12 = "jdkc.12";
    private static final String JDKC_STATUS_13 = "jdkc.13";
    private static final String JDKC_STATUS_14 = "jdkc.14";
    private static final String JDKC_STATUS_15 = "jdkc.15";
    private static final String JDKC_STATUS_17 = "jdkc.17";
    private Stack contextStack = new Stack();
    private Stack envStack = new Stack();
    private Stack enclCompUnitStack = new Stack();
    private Stack tryCatchStacks = new Stack();
    private Stack typeStack = new Stack();
    private RestrictedComponents rc;
    private HashSet checkedInterfaces;

    public String getTestName() {
        return TEST_NAME;
    }

    private void initialize() {
        String tempRestrictedComponentsList = (String)((Object)this.getInputParameter(PARAMETER_GRAMMAR_FILE));
        try {
            BufferedReader fr = new BufferedReader(new FileReader(tempRestrictedComponentsList));
            this.rc = new RestrictedComponents(XMLTool.parseReader((Reader)fr));
            ((Reader)fr).close();
        }
        catch (Exception e) {
            this.logException(e);
        }
    }

    public void setParameters(ParameterInterface[] parameters, TestObject testObject) {
        super.setParameters(parameters, testObject);
        this.initialize();
    }

    public boolean visit(ITypeDeclaration typeDeclaration) {
        this.typeStack.push(typeDeclaration.resolveBinding());
        this.contextStack.push(new HashSet());
        this.tryCatchStacks.push(new Stack());
        this.envStack.push(typeDeclaration.resolveBinding());
        this.testTypeDeclaration(typeDeclaration.resolveBinding(), (Position)typeDeclaration);
        if (typeDeclaration.getName().getIdentifier() != null && KEYWORD_ASSERT.equals(typeDeclaration.getName().getIdentifier())) {
            this.incompatError((Position)typeDeclaration, JDKC_STATUS_12);
        }
        return true;
    }

    public void endVisit(ITypeDeclaration typeDeclaration) {
        this.typeStack.pop();
        this.contextStack.pop();
        this.envStack.pop();
        this.tryCatchStacks.push(new Stack());
    }

    public boolean visit(ICompilationUnit cU) {
        this.enclCompUnitStack.push(cU);
        this.contextStack.push(new HashSet());
        if (cU.getPackage() != null) {
            this.envStack.push(cU.getPackage().resolveBinding());
        }
        return true;
    }

    public boolean visit(IAnonymousClassDeclaration typeDeclaration) {
        this.typeStack.push(typeDeclaration.resolveBinding());
        this.contextStack.push(new HashSet());
        this.envStack.push(typeDeclaration.resolveBinding());
        this.tryCatchStacks.push(new Stack());
        this.testTypeDeclaration(typeDeclaration.resolveBinding(), (Position)typeDeclaration);
        return true;
    }

    public boolean visit(IVariableDeclaration varDecl) {
        if (KEYWORD_ASSERT.equals(varDecl.getName())) {
            this.incompatError((Position)varDecl, JDKC_STATUS_12);
        }
        return true;
    }

    public boolean visit(ISimpleType st) {
        this.checkType(st.resolveBinding(), (Position)st);
        return true;
    }

    public void endVisit(IAnonymousClassDeclaration typeDeclaration) {
        this.typeStack.pop();
        this.contextStack.pop();
        this.envStack.pop();
        this.tryCatchStacks.pop();
    }

    public void endVisit(ICompilationUnit compilationUnitDeclaration) {
        this.contextStack.pop();
        if (compilationUnitDeclaration.getPackage() != null) {
            this.envStack.pop();
        }
        this.enclCompUnitStack.pop();
    }

    public boolean visit(IAssignment ass) {
        IExpression lhs = ass.getLeftHandSide();
        if (!(lhs instanceof IFieldAccess)) {
            return true;
        }
        IFieldAccess fAcc = (IFieldAccess)lhs;
        String accessedClass = fAcc.getExpression().resolveTypeBinding().getName();
        String selector = fAcc.getName();
        if (DEFAULT_PAINTER.equals(selector) && DEFAULT_HIGHLIGHTER.equals(accessedClass)) {
            this.incompatError((Position)ass, JDKC_STATUS_3);
        }
        return true;
    }

    public boolean visit(IConstructorInvocation constCall) {
        try {
            IMethodBinding methBind = constCall.resolveConstructorBinding();
            RCStatusInfo status = this.getStatus((IBinding)methBind);
            if (!status.getStatus().equals("OK")) {
                this.error((Position)constCall, status);
            }
        }
        catch (Exception e) {
            this.logException(e, (Position)constCall);
            return false;
        }
        return true;
    }

    public boolean visit(ITypeLiteral classLiteral) {
        ITypeBinding currClass = classLiteral.resolveTypeBinding();
        if (currClass.isArray()) {
            currClass = ((IArrayTypeBinding)currClass).getElementType();
        }
        if (currClass.isPrimitive()) {
            return true;
        }
        if (this.isSubtypeOf((IReferenceTypeBinding)currClass, SERIALIZABLE) && ((IReferenceTypeBinding)currClass).isNested()) {
            this.incompatError((Position)classLiteral, JDKC_STATUS_2);
        }
        if ((currClass = (ITypeBinding)this.typeStack.peek()).isArray()) {
            currClass = ((IArrayTypeBinding)currClass).getElementType();
        }
        if (currClass.isPrimitive()) {
            return true;
        }
        if (this.isSubtypeOf((IReferenceTypeBinding)currClass, SERIALIZABLE) && ((IReferenceTypeBinding)currClass).isNested() && (!this.declaresSerialVersionUID((IReferenceTypeBinding)currClass) || this.isSubtypeOf(((IReferenceTypeBinding)currClass).getDeclaringClass(), SERIALIZABLE) && !this.declaresSerialVersionUID(((IReferenceTypeBinding)currClass).getDeclaringClass()))) {
            this.incompatError((Position)classLiteral, JDKC_STATUS_2);
        }
        return true;
    }

    public boolean visit(IMethodInvocation methCall) {
        IVariableDeclaration handler = null;
        try {
            IMethodBinding methBind = methCall.resolveMethodBinding();
            RCStatusInfo statusInfo = this.getStatus((IBinding)methBind);
            String status = statusInfo.getStatus();
            if (!status.equals("OK")) {
                if (status.equals(JDKC_STATUS_1)) {
                    handler = this.checkCatch(EXCEPTION_ILLEGAL_ARGUMENT);
                    if (null != handler) {
                        this.incompatError((Position)handler, status);
                    }
                } else if (status.equals(JDKC_STATUS_11)) {
                    handler = this.checkCatch(EXCEPTION_FILE_NOT_FOUND);
                    if (null != handler) {
                        this.incompatError((Position)handler, status);
                    }
                } else if (status.equals(JDKC_STATUS_15)) {
                    List args = methCall.arguments();
                    IExpression firstArg = (IExpression)args.get(0);
                    if (firstArg instanceof IStringLiteral && JSSE_PROPERTY.equals(((IStringLiteral)firstArg).getLiteralValue())) {
                        this.incompatError((Position)methCall, JDKC_STATUS_15);
                    }
                } else {
                    this.error((Position)methCall, statusInfo);
                }
            }
        }
        catch (Exception e) {
            this.logException(e, (Position)methCall);
            return false;
        }
        return true;
    }

    public boolean visit(ITryStatement tryStmt) {
        Stack lclTryCatchStack = (Stack)this.tryCatchStacks.peek();
        lclTryCatchStack.push(tryStmt);
        return true;
    }

    public void endVisit(ITryStatement tryStmt) {
        Stack lclTryCatchStack = (Stack)this.tryCatchStacks.peek();
        lclTryCatchStack.push(tryStmt);
    }

    public boolean visit(IMethodDeclaration methDecl) {
        Stack lclTryCatchStack = (Stack)this.tryCatchStacks.peek();
        lclTryCatchStack.clear();
        if (KEYWORD_ASSERT.equals(methDecl.getName())) {
            this.incompatError((Position)methDecl, JDKC_STATUS_12);
        }
        return true;
    }

    public boolean visit(IFieldDeclaration fieldDeclaration) {
        if (KEYWORD_ASSERT.equals(fieldDeclaration.getName())) {
            this.incompatError((Position)fieldDeclaration, JDKC_STATUS_12);
        }
        return true;
    }

    public boolean visit(IFieldAccess fa) {
        this.checkType(fa.resolveTypeBinding(), (Position)fa);
        try {
            IVariableBinding varBind = fa.resolveBinding();
            if (varBind.getDeclaringClass() == null) {
                return true;
            }
            RCStatusInfo statusInfo = this.getStatus((IBinding)varBind);
            String status = statusInfo.getStatus();
            if (!status.equals("OK")) {
                this.error((Position)fa, statusInfo);
            }
        }
        catch (Exception e) {
            this.logException(e, (Position)fa);
            return false;
        }
        return true;
    }

    public boolean visit(IInitializer init) {
        Stack lclTryCatchStack = (Stack)this.tryCatchStacks.peek();
        lclTryCatchStack.clear();
        return true;
    }

    public boolean visit(IQualifiedName qn) {
        String qnString = qn.getName();
        if (qnString != null && qnString.charAt(qnString.length() - 1) == '*') {
            return true;
        }
        try {
            ITypeBinding type = qn.resolveTypeBinding();
            if (type == null) {
                return true;
            }
            this.checkType(type, (Position)qn);
        }
        catch (Exception e) {
            this.logException(e, (Position)qn);
        }
        return true;
    }

    public boolean visit(ISimpleName node) {
        ITypeBinding binding = node.resolveTypeBinding();
        if (binding != null) {
            this.checkType(binding, (Position)node);
        }
        return true;
    }

    private void checkType(ITypeBinding type, Position pos) {
        try {
            if (type.isArray()) {
                type = ((IArrayTypeBinding)type).getElementType();
            }
            if (type.isPrimitive()) {
                return;
            }
            RCStatusInfo statusInfo = this.getStatus((IBinding)((IReferenceTypeBinding)type));
            String status = statusInfo.getStatus();
            if (!status.equals("OK")) {
                this.error(pos, statusInfo);
            }
        }
        catch (Exception e) {
            this.logException(e, pos);
        }
    }

    private void testTypeDeclaration(IReferenceTypeBinding binding, Position pos) {
        try {
            String methName;
            int i;
            IMethodBinding[] methods;
            if (this.isSubtypeOf(binding, OBJECT_OUTPUT_STREAM)) {
                methods = binding.getDeclaredMethods();
                i = 0;
                while (i < methods.length) {
                    methName = methods[i].getName();
                    if (METHOD_PUT_FIELDS.equals(methName) && 0 == methods[i].getParameterTypes().length) {
                        this.incompatError(pos, JDKC_STATUS_7_1);
                    }
                    ++i;
                }
            } else if (this.isSubtypeOf(binding, OBJECT_INPUT_STREAM)) {
                methods = binding.getDeclaredMethods();
                i = 0;
                while (i < methods.length) {
                    methName = methods[i].getName();
                    if (METHOD_READ_FIELDS.equals(methName) && 0 == methods[i].getParameterTypes().length) {
                        this.incompatError(pos, JDKC_STATUS_7_2);
                    }
                    ++i;
                }
            }
            IReferenceTypeBinding[] interfaces = binding.getInterfaces();
            if (this.implementsInterface(binding, SERIALIZABLE) && !this.declaresSerialVersionUID(binding) && Modifier.isAbstract(binding.getModifiers()) && !binding.isInterface()) {
                IMethodBinding[] allMeths = binding.getDeclaredMethods();
                int j = 0;
                while (j < allMeths.length) {
                    if (Modifier.isAbstract(allMeths[j].getModifiers())) {
                        boolean found = false;
                        int i2 = 0;
                        block5: while (i2 < interfaces.length) {
                            IMethodBinding[] intfMeths = interfaces[i2].getDeclaredMethods();
                            int k = 0;
                            while (k < intfMeths.length) {
                                if (allMeths[j].getName().equals(intfMeths[k].getName())) {
                                    found = true;
                                    break block5;
                                }
                                ++k;
                            }
                            ++i2;
                        }
                        if (found) {
                            this.incompatError(pos, JDKC_STATUS_9);
                        }
                    }
                    ++j;
                }
            }
            int i3 = 0;
            while (i3 < interfaces.length) {
                if (interfaces[i3].getName().equals(INTERFACE_APPLET_CONTEXT)) {
                    this.incompatError(pos, JDKC_STATUS_13);
                }
                ++i3;
            }
            if (!Modifier.isAbstract(binding.getModifiers()) && this.isSubtypeOf(binding, CLASS_SOCKET_IMPL)) {
                this.incompatError(pos, JDKC_STATUS_14);
            }
            if (this.isSubtypeOf(binding, INTERFACE_DROPTARGET_LISTENER)) {
                IMethodBinding[] allMeths = binding.getDeclaredMethods();
                int i4 = 0;
                while (i4 < allMeths.length) {
                    if (!Modifier.isAbstract(allMeths[i4].getModifiers()) && (METHOD_DROP.equals(allMeths[i4].getName()) || METHOD_DRAG_EXIT.equals(allMeths[i4].getName()))) {
                        this.incompatError(pos, JDKC_STATUS_17);
                    }
                    ++i4;
                }
            }
        }
        catch (Exception e) {
            this.logException(e, pos);
        }
    }

    private void incompatError(Position pos, String status) {
        this.addError(status, COMPATIBILITY_URL, null, pos);
    }

    private boolean isSubtypeOf(IReferenceTypeBinding clType, String name) {
        IReferenceTypeBinding parent = clType.getSuperclass();
        if (parent != null) {
            if (name.equals(parent.getName())) {
                return true;
            }
            if (this.isSubtypeOf(parent, name)) {
                return true;
            }
        }
        IReferenceTypeBinding[] interfaces = clType.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (name.equals(interfaces[i].getName())) {
                return true;
            }
            if (this.isSubtypeOf(interfaces[i], name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IVariableDeclaration checkCatch(String excName) {
        Stack lclTryCatchStack = (Stack)this.tryCatchStacks.peek();
        int stackLen = lclTryCatchStack.size();
        int i = stackLen - 1;
        while (i >= 0) {
            List catchClauseList = ((ITryStatement)lclTryCatchStack.get(i)).catchClauses();
            if (catchClauseList != null || !catchClauseList.isEmpty()) {
                Iterator it = catchClauseList.iterator();
                while (it.hasNext()) {
                    ICatchClause catchClause = (ICatchClause)it.next();
                    IVariableDeclaration argument = catchClause.getException();
                    ITypeBinding caughtExc = argument.getType().resolveBinding();
                    if (caughtExc.getName().equals(excName)) {
                        return argument;
                    }
                    String caughtExcName = caughtExc.getName();
                    if (!EXCEPTION_FILE_NOT_FOUND.equals(excName)) continue;
                    if (EXCEPTION_IO.equals(caughtExcName) || EXCEPTION.equals(caughtExcName) || THROWABLE.equals(caughtExcName)) {
                        return null;
                    }
                    if (!EXCEPTION_ILLEGAL_ARGUMENT.equals(excName) || !EXCEPTION_RUNTIME.equals(caughtExcName) && !EXCEPTION.equals(caughtExcName) && !THROWABLE.equals(caughtExcName)) continue;
                    return null;
                }
            }
            --i;
        }
        return null;
    }

    private void error(Position position, RCStatusInfo status) {
        this.addError(status.getStatus(), COMPATIBILITY_URL, null, position);
    }

    private boolean implementsInterface(IReferenceTypeBinding type, String interfaceFullName) {
        this.checkedInterfaces = new HashSet();
        return this.implementsInterfaceInt(type, interfaceFullName);
    }

    private boolean implementsInterfaceInt(IReferenceTypeBinding type, String interfaceName) {
        IReferenceTypeBinding[] interfaces = type.getInterfaces();
        if (interfaceName == null || interfaces.length == 0) {
            return false;
        }
        int i = 0;
        while (i < interfaces.length) {
            if (!this.checkedInterfaces.contains(interfaces[i])) {
                this.checkedInterfaces.add(interfaces[i]);
                if (interfaceName.equals(interfaces[i].getName())) {
                    return true;
                }
                if (this.implementsInterfaceInt(interfaces[i], interfaceName)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean declaresSerialVersionUID(IReferenceTypeBinding bnd) {
        IVariableBinding[] fields = bnd.getDeclaredFields();
        boolean serialVerDeclared = false;
        int i = 0;
        while (i < fields.length) {
            ITypeBinding fieldType;
            int mod = fields[i].getModifiers();
            if (fields[i].getName().equals(SER_VER_UID_NAME) && Modifier.isStatic(mod) && Modifier.isFinal(mod) && (fieldType = fields[i].getType()).isPrimitive() && "long".equals(fieldType.getName())) {
                serialVerDeclared = true;
                break;
            }
            ++i;
        }
        return serialVerDeclared;
    }

    public boolean visit(IClassInstanceCreation node) {
        IVariableDeclaration handler = null;
        try {
            IMethodBinding methBind = node.resolveConstructorBinding();
            RCStatusInfo statusInfo = this.getStatus((IBinding)methBind);
            String status = statusInfo.getStatus();
            if (!status.equals("OK")) {
                if (status.equals(JDKC_STATUS_1)) {
                    handler = this.checkCatch(EXCEPTION_ILLEGAL_ARGUMENT);
                    if (null != handler) {
                        this.incompatError((Position)handler, status);
                    }
                } else {
                    this.error((Position)node, statusInfo);
                }
            }
        }
        catch (Exception e) {
            this.logException(e, (Position)node);
            return false;
        }
        return true;
    }

    public boolean visit(IVariableDeclarationStatement node) {
        if (KEYWORD_ASSERT.equals(node.getName())) {
            this.incompatError((Position)node, JDKC_STATUS_12);
        }
        return true;
    }

    private RCStatusInfo getStatus(IBinding bnd) {
        return this.rc.getStatusInfo((IBinding)this.envStack.peek(), bnd);
    }
}

