/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.flow;

import com.sap.tc.jtools.jlint.java.flow.BooleanFlowLineMethod;
import com.sap.tc.jtools.jlint.java.flow.FlowLine;
import com.sap.tc.jtools.jlint.java.flow.FlowLineManipulator;
import com.sap.tc.jtools.jlint.jom.JomTestVisitorWithFlow;
import com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit;
import com.sap.tc.jtools.jlint.jom.interfaces.IIfStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;

public class FlowTest
extends JomTestVisitorWithFlow {
    private static final Manipulator manipulator = new Manipulator();
    private static final BooleanFlowLineMethod checker = new Checker();
    private static final String NAME = "Flow Test";

    public String getTestName() {
        return NAME;
    }

    public boolean visit(ICompilationUnit node) {
        this.addFlowLine("type1", new VerySimpleFlowLine());
        return super.visit(node);
    }

    public boolean visit(IMethodDeclaration node) {
        this.resetFlow("type1");
        this.addFlowLine("type1", new VerySimpleFlowLine());
        return super.visit(node);
    }

    public void endVisit(IMethodDeclaration node) {
        boolean check = this.check("type1", checker);
        if (!check) {
            this.addError("MK", null, (Position)node);
        }
    }

    public boolean visit(IMethodInvocation node) {
        this.manipulateFlow("type1", manipulator);
        return true;
    }

    public boolean visitExternal(IIfStatement stmt) {
        return true;
    }

    public void endVisitExternal(IIfStatement stmt) {
    }

    private static class VerySimpleFlowLine
    implements FlowLine {
        private boolean value = false;

        private VerySimpleFlowLine() {
        }

        public FlowLine deepCopy() {
            VerySimpleFlowLine copy = new VerySimpleFlowLine();
            copy.value = this.value;
            return copy;
        }

        public boolean isValue() {
            return this.value;
        }

        public void setValue(boolean b) {
            this.value = b;
        }
    }

    private static class Checker
    extends BooleanFlowLineMethod {
        private Checker() {
        }

        public boolean isTrue(FlowLine fl) {
            return ((VerySimpleFlowLine)fl).isValue();
        }
    }

    private static class Manipulator
    extends FlowLineManipulator {
        private Manipulator() {
        }

        public FlowLine[] manipulate(FlowLine fl) {
            VerySimpleFlowLine vsfl = (VerySimpleFlowLine)fl.deepCopy();
            vsfl.setValue(true);
            return new FlowLine[]{vsfl};
        }
    }
}

