/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.exception.rewrite;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayInitializer;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IAssignment;
import com.sap.tc.jtools.jlint.jom.interfaces.IBlock;
import com.sap.tc.jtools.jlint.jom.interfaces.ICatchClause;
import com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.ICompilationUnit;
import com.sap.tc.jtools.jlint.jom.interfaces.IEmptyStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IFieldAccess;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IReturnStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IThrowStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.util.InheritanceTool;
import com.sap.tc.jtools.jlint.tests.exception.rewrite.CatchBlockInfo;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;

public class CatchBlockTest
extends JomTestVisitor {
    private static final String NAME = "New Catch Block Test";
    private Stack catchBlockInfoStack = new Stack();
    private static final String THROWABLE = (class$java$lang$Throwable == null ? (class$java$lang$Throwable = CatchBlockTest.class$("java.lang.Throwable")) : class$java$lang$Throwable).getName();
    private static final String OBJECT = (class$java$lang$Object == null ? (class$java$lang$Object = CatchBlockTest.class$("java.lang.Object")) : class$java$lang$Object).getName();
    private static final String SYSTEM = (class$java$lang$System == null ? (class$java$lang$System = CatchBlockTest.class$("java.lang.System")) : class$java$lang$System).getName();
    private static final String MSG_KEY_EXC_NOT_NESTED = "newcatchblock.1";
    private static final String MSG_KEY_EXC_NO_GOOD_PATTERN_FOUND = "newcatchblock.2";
    private static final String MSG_KEY_EMPTY_CATCH_BLOCK = "newcatchblock.3";
    private static final String METH_PRINTSTACKTRACE = "printStackTrace";
    private static final String METH_TOSTRING = "toString";
    private static final String METH_GETCLASS = "getClass";
    private static final String METH_EQUALS = "equals";
    private static final String METH_HASHCODE = "hashCode";
    private static final String METH_WAIT = "wait";
    private static final String METH_NOTIFY = "notify";
    private static final String METH_NOTIFYALL = "notifyAll";
    private static final String METH_GETMESSAGE = "getMessage";
    private static final String METH_GETLOCMESSAGE = "getLocalizedMessage";
    private static final Set BAD_METH_NAMES = new HashSet();
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$System;
    static /* synthetic */ Class class$java$io$PrintStream;

    public boolean visit(IArrayCreation node) {
        if (!this.isUsageCheckNecessary()) {
            return true;
        }
        IArrayInitializer arrayInit = node.getInitializer();
        if (arrayInit == null) {
            return true;
        }
        List exprs = arrayInit.expressions();
        Iterator iter = exprs.iterator();
        while (iter.hasNext()) {
            IExpression expr = (IExpression)iter.next();
            if (!CatchBlockTest.extendsThrowableOrThrowableArray(expr.resolveTypeBinding())) continue;
            this.getCurrentCatchBlockInfo().setGoodUsagePatternFound(true);
            return true;
        }
        return true;
    }

    public boolean visit(IAssignment node) {
        if (!this.isUsageCheckNecessary()) {
            return true;
        }
        ITypeBinding bnd = node.getRightHandSide().resolveTypeBinding();
        if (!(bnd instanceof IReferenceTypeBinding)) {
            return true;
        }
        if (CatchBlockTest.extendsThrowableOrThrowableArray((ITypeBinding)((IReferenceTypeBinding)bnd))) {
            this.getCurrentCatchBlockInfo().setGoodUsagePatternFound(true);
        }
        return true;
    }

    private boolean isUsageCheckNecessary() {
        return this.insideCatchBlock() && !this.getCurrentCatchBlockInfo().isAnyUsagePatternFound();
    }

    private static boolean extendsThrowableOrThrowableArray(ITypeBinding binding) {
        if (!(binding instanceof IReferenceTypeBinding)) {
            return false;
        }
        IReferenceTypeBinding refBnd = (IReferenceTypeBinding)binding;
        if (refBnd.isArray()) {
            ITypeBinding elementBnd = ((IArrayTypeBinding)refBnd).getElementType();
            if (!(elementBnd instanceof IReferenceTypeBinding)) {
                return false;
            }
            refBnd = (IReferenceTypeBinding)elementBnd;
        }
        return InheritanceTool.bndExtends((IReferenceTypeBinding)refBnd, (String)THROWABLE);
    }

    private static boolean isObjectOrObjectArray(ITypeBinding binding) {
        if (!(binding instanceof IReferenceTypeBinding)) {
            return false;
        }
        IReferenceTypeBinding refBnd = (IReferenceTypeBinding)binding;
        if (refBnd.isArray()) {
            ITypeBinding elementBnd = ((IArrayTypeBinding)refBnd).getElementType();
            if (!(elementBnd instanceof IReferenceTypeBinding)) {
                return false;
            }
            refBnd = (IReferenceTypeBinding)elementBnd;
        }
        return OBJECT.equals(refBnd.getName());
    }

    private static boolean extendsThrowable(ITypeBinding binding) {
        if (!(binding instanceof IReferenceTypeBinding)) {
            return false;
        }
        IReferenceTypeBinding refBnd = (IReferenceTypeBinding)binding;
        if (refBnd.isArray()) {
            return false;
        }
        return InheritanceTool.bndExtends((IReferenceTypeBinding)refBnd, (String)THROWABLE);
    }

    public boolean visit(IClassInstanceCreation node) {
        if (!this.isUsageCheckNecessary()) {
            return true;
        }
        this.checkMethodOrConstructorInvocation(node.resolveConstructorBinding(), node.arguments());
        return true;
    }

    public boolean visit(ICompilationUnit node) {
        this.catchBlockInfoStack.clear();
        return true;
    }

    public boolean visit(IMethodInvocation node) {
        if (!this.isUsageCheckNecessary()) {
            return true;
        }
        this.checkIfGoodUsageMethodOfThrowable(node);
        this.checkMethodOrConstructorInvocation(node.resolveMethodBinding(), node.arguments());
        return true;
    }

    private void checkIfGoodUsageMethodOfThrowable(IMethodInvocation node) {
        IExpression expr = node.getExpression();
        if (expr == null || !CatchBlockTest.extendsThrowable(expr.resolveTypeBinding())) {
            return;
        }
        IMethodBinding methBnd = node.resolveMethodBinding();
        String methName = node.getName();
        if (!BAD_METH_NAMES.contains(methName)) {
            this.getCurrentCatchBlockInfo().setGoodUsagePatternFound(true);
            return;
        }
        if (METH_PRINTSTACKTRACE.equals(methName)) {
            if (!this.isPrintStackTraceSystemOutOrErr(node)) {
                this.getCurrentCatchBlockInfo().setGoodUsagePatternFound(true);
                return;
            }
        } else if (METH_TOSTRING.equals(methName) || METH_GETCLASS.equals(methName) || METH_EQUALS.equals(methName) || METH_HASHCODE.equals(methName) || METH_WAIT.equals(methName) || METH_NOTIFY.equals(methName) || METH_NOTIFYALL.equals(methName) || METH_GETMESSAGE.equals(methName) || METH_GETLOCMESSAGE.equals(methName)) {
            // empty if block
        }
    }

    private boolean isPrintStackTraceSystemOutOrErr(IMethodInvocation node) {
        IMethodBinding methBnd = node.resolveMethodBinding();
        ITypeBinding[] paramTypes = methBnd.getParameterTypes();
        if (paramTypes.length == 0) {
            return true;
        }
        if (paramTypes.length == 1) {
            ITypeBinding bnd;
            IFieldAccess fAcc;
            String fieldName;
            IExpression actualParam;
            ITypeBinding param = methBnd.getParameterTypes()[0];
            if (!(param instanceof IReferenceTypeBinding)) {
                return false;
            }
            if (InheritanceTool.bndExtends((IReferenceTypeBinding)((IReferenceTypeBinding)param), (String)(class$java$io$PrintStream == null ? (class$java$io$PrintStream = CatchBlockTest.class$("java.io.PrintStream")) : class$java$io$PrintStream).getName()) && (actualParam = (IExpression)node.arguments().get(0)) instanceof IFieldAccess && ("out".equals(fieldName = (fAcc = (IFieldAccess)actualParam).getName()) || "err".equals(fieldName)) && SYSTEM.equals((bnd = fAcc.getExpression().resolveTypeBinding()).getName())) {
                return true;
            }
        }
        return false;
    }

    public boolean visit(IReturnStatement node) {
        if (!this.isUsageCheckNecessary()) {
            return true;
        }
        IExpression expr = node.getExpression();
        if (expr != null && CatchBlockTest.extendsThrowableOrThrowableArray(expr.resolveTypeBinding())) {
            this.getCurrentCatchBlockInfo().setGoodUsagePatternFound(true);
        }
        return true;
    }

    public boolean visit(IThrowStatement node) {
        if (!this.insideCatchBlock()) {
            return true;
        }
        if (this.isBadThrowUsage(node)) {
            this.getCurrentCatchBlockInfo().setBadUsagePatternFound(true);
            this.addError(MSG_KEY_EXC_NOT_NESTED, null, (Position)node);
        } else {
            this.getCurrentCatchBlockInfo().setGoodUsagePatternFound(true);
        }
        return true;
    }

    private boolean isBadThrowUsage(IThrowStatement node) {
        IExpression expr = node.getExpression();
        if (!(expr instanceof IClassInstanceCreation)) {
            return false;
        }
        List args = ((IClassInstanceCreation)expr).arguments();
        Iterator iter = args.iterator();
        while (iter.hasNext()) {
            IExpression argExpr = (IExpression)iter.next();
            if (!CatchBlockTest.extendsThrowableOrThrowableArray(argExpr.resolveTypeBinding())) continue;
            return false;
        }
        return true;
    }

    public String getTestName() {
        return NAME;
    }

    public void endVisit(ICatchClause node) {
        CatchBlockInfo cbInfo = (CatchBlockInfo)this.catchBlockInfoStack.pop();
        if (cbInfo.isAnyUsagePatternFound()) {
            return;
        }
        this.addError(MSG_KEY_EXC_NO_GOOD_PATTERN_FOUND, null, (Position)node);
    }

    public boolean visit(ICatchClause node) {
        this.catchBlockInfoStack.push(new CatchBlockInfo());
        this.checkForEmptyCatchBlock(node);
        return true;
    }

    private void checkForEmptyCatchBlock(ICatchClause node) {
        IBlock catchBlock = node.getBody();
        List stmts = catchBlock.statements();
        if (stmts.size() == 0 || stmts.size() == 1 && stmts.get(0) instanceof IEmptyStatement) {
            this.getCurrentCatchBlockInfo().setBadUsagePatternFound(true);
            Properties p = new Properties();
            p.setProperty("EXCEPTION", node.getException().getType().resolveBinding().getName());
            this.addError(MSG_KEY_EMPTY_CATCH_BLOCK, p, (Position)node);
        }
    }

    private boolean insideCatchBlock() {
        return !this.catchBlockInfoStack.isEmpty();
    }

    private CatchBlockInfo getCurrentCatchBlockInfo() {
        return (CatchBlockInfo)this.catchBlockInfoStack.peek();
    }

    private void checkMethodOrConstructorInvocation(IMethodBinding bnd, List arguments) {
        ITypeBinding[] formalParams = bnd.getParameterTypes();
        int i = 0;
        Iterator iter = arguments.iterator();
        while (iter.hasNext()) {
            IExpression arg = (IExpression)iter.next();
            if (CatchBlockTest.extendsThrowableOrThrowableArray(arg.resolveTypeBinding()) && !CatchBlockTest.isObjectOrObjectArray(formalParams[i])) {
                this.getCurrentCatchBlockInfo().setGoodUsagePatternFound(true);
                return;
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        BAD_METH_NAMES.addAll(Arrays.asList(METH_PRINTSTACKTRACE, METH_TOSTRING, METH_GETCLASS, METH_EQUALS, METH_HASHCODE, METH_WAIT, METH_NOTIFY, METH_NOTIFYALL, METH_GETMESSAGE, METH_GETLOCMESSAGE));
    }
}

