/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.exception;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.ICatchClause;
import com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ISuperConstructorInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.ISuperMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IThrowStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.util.InheritanceTool;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.util.collections.BooleanStack;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;

public class ExceptionTest
extends JomTestVisitor {
    private static final String NAME = "ExceptionTest";
    private static final String MSG_KEY_2 = "exc.2";
    private static final String MSG_KEY_3 = "exc.3";
    private static final String MSG_KEY_4 = "exc.4";
    private static final String MSG_KEY_5 = "exc.5";
    private static final String MSG_KEY_6 = "exc.6";
    private static final String MSG_KEY_7 = "exc.7";
    private static final String MSG_KEY_8 = "exc.8";
    private static final String THROWABLE = "java.lang.Throwable";
    private static final String EXCEPTION = "java.lang.Exception";
    private static final String RUNTIME_EXCEPTION = "java.lang.RuntimeException";
    private static final String PAR_CHECK_DECARED_EXC = "CHECK_DECLARED_EXC";
    private static final String PAR_CHECK_TOO_GENERIC_EXC = "CHECK_TOO_GENERIC_EXC";
    private static final String MSG_PAR_EXCEPTION = "EXCEPTION";
    private static final String MSG_PAR_THROWABLE = "THROWABLE";
    private Stack throwsStack = new Stack();
    private BooleanStack inCatchBlockStack = new BooleanStack();
    private boolean checkTooGenericExceptions = false;
    private boolean checkIfDeclaredExcReallyThrown = false;

    public String getTestName() {
        return NAME;
    }

    public boolean visit(ICatchClause node) {
        this.inCatchBlockStack.pop();
        this.inCatchBlockStack.push(true);
        ITypeBinding excType = node.getException().resolveBinding().getType();
        if (!(excType instanceof IReferenceTypeBinding)) {
            return true;
        }
        IReferenceTypeBinding excRefType = (IReferenceTypeBinding)excType;
        if (InheritanceTool.bndExtends((IReferenceTypeBinding)excRefType, (String)THROWABLE) && !InheritanceTool.bndExtends((IReferenceTypeBinding)excRefType, (String)EXCEPTION)) {
            this.addError(MSG_KEY_3, null, (Position)node);
        }
        String excName = excRefType.getName();
        if (this.checkTooGenericExceptions && (EXCEPTION.equals(excName) || RUNTIME_EXCEPTION.equals(excName))) {
            Properties p = new Properties();
            p.setProperty(MSG_PAR_EXCEPTION, excName);
            this.addError(MSG_KEY_7, p, (Position)node);
        }
        return true;
    }

    public boolean visit(IThrowStatement node) {
        IReferenceTypeBinding excBnd = (IReferenceTypeBinding)node.getExpression().resolveTypeBinding();
        if (InheritanceTool.bndExtends((IReferenceTypeBinding)excBnd, (String)THROWABLE) && !InheritanceTool.bndExtends((IReferenceTypeBinding)excBnd, (String)EXCEPTION)) {
            this.addError(MSG_KEY_4, null, (Position)node);
        }
        String excName = excBnd.getName();
        if (this.checkTooGenericExceptions && (EXCEPTION.equals(excName) || RUNTIME_EXCEPTION.equals(excName))) {
            Properties p = new Properties();
            p.setProperty(MSG_PAR_EXCEPTION, excName);
            this.addError(MSG_KEY_8, p, (Position)node);
        }
        if (!this.throwsStack.isEmpty()) {
            Map excMap = (Map)this.throwsStack.peek();
            Set declExcNames = excMap.keySet();
            Iterator iter = declExcNames.iterator();
            while (iter.hasNext()) {
                String declExcName = (String)iter.next();
                if (!InheritanceTool.bndExtends((IReferenceTypeBinding)excBnd, (String)declExcName)) continue;
                excMap.put(declExcName, Boolean.TRUE);
            }
        }
        if (this.inCatchBlockStack.peek()) {
            this.checkForLostStackTrace(node);
        }
        return true;
    }

    private void checkForLostStackTrace(IThrowStatement node) {
        if (!(node.getExpression() instanceof IClassInstanceCreation)) {
            return;
        }
        List args = ((IClassInstanceCreation)node.getExpression()).arguments();
        boolean throwableArgumentFound = false;
        Iterator iter = args.iterator();
        while (iter.hasNext() && !throwableArgumentFound) {
            IExpression argument = (IExpression)iter.next();
            ITypeBinding argumentBnd = argument.resolveTypeBinding();
            if (!(argumentBnd instanceof IReferenceTypeBinding)) continue;
            throwableArgumentFound = InheritanceTool.bndExtends((IReferenceTypeBinding)((IReferenceTypeBinding)argumentBnd), (String)THROWABLE);
        }
    }

    public boolean visit(ITypeDeclaration node) {
        this.inCatchBlockStack.push(false);
        if (InheritanceTool.bndExtends((IReferenceTypeBinding)node.resolveBinding(), (String)THROWABLE) && !InheritanceTool.bndExtends((IReferenceTypeBinding)node.resolveBinding(), (String)EXCEPTION)) {
            this.addError(MSG_KEY_5, null, (Position)node);
        }
        return true;
    }

    public boolean visit(IMethodDeclaration node) {
        IReferenceTypeBinding[] excs = node.resolveBinding().getExceptionTypes();
        HashMap<String, Boolean> excMap = new HashMap<String, Boolean>();
        int i = 0;
        while (i < excs.length) {
            String excName = excs[i].getName();
            if (this.checkTooGenericExceptions && (EXCEPTION.equals(excName) || RUNTIME_EXCEPTION.equals(excName))) {
                Properties p = new Properties();
                p.setProperty(MSG_PAR_EXCEPTION, excName);
                this.addError(MSG_KEY_2, p, (Position)node);
            }
            excMap.put(excName, Boolean.FALSE);
            ++i;
        }
        this.throwsStack.push(excMap);
        return true;
    }

    public void endVisit(IMethodDeclaration node) {
        Map excMap = (Map)this.throwsStack.pop();
        if (!this.checkIfDeclaredExcReallyThrown || Modifier.isAbstract(node.resolveBinding().getModifiers())) {
            return;
        }
        Set keys = excMap.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String excName = (String)iter.next();
            Boolean reallyThrown = (Boolean)excMap.get(excName);
            if (reallyThrown.booleanValue()) continue;
            Properties p = new Properties();
            p.setProperty(MSG_PAR_THROWABLE, excName);
            this.addError(MSG_KEY_6, p, (Position)node);
        }
    }

    public boolean visit(IClassInstanceCreation node) {
        this.addThrownExceptions(node.resolveConstructorBinding());
        return true;
    }

    private void addThrownExceptions(IMethodBinding binding) {
        if (this.throwsStack.isEmpty()) {
            return;
        }
        Map excMap = (Map)this.throwsStack.peek();
        Set declExcNames = excMap.keySet();
        IReferenceTypeBinding[] excTypes = binding.getExceptionTypes();
        int i = 0;
        while (i < excTypes.length) {
            Iterator iter = declExcNames.iterator();
            while (iter.hasNext()) {
                String declExcName = (String)iter.next();
                if (!InheritanceTool.bndExtends((IReferenceTypeBinding)excTypes[i], (String)declExcName)) continue;
                excMap.put(declExcName, Boolean.TRUE);
            }
            ++i;
        }
    }

    public boolean visit(IMethodInvocation node) {
        this.addThrownExceptions(node.resolveMethodBinding());
        return true;
    }

    public boolean visit(ISuperConstructorInvocation node) {
        this.addThrownExceptions(node.resolveConstructorBinding());
        return true;
    }

    public boolean visit(ISuperMethodInvocation node) {
        this.addThrownExceptions(node.resolveMethodBinding());
        return true;
    }

    public void setParameters(ParameterInterface[] parameters, TestObject testObject) {
        super.setParameters(parameters, testObject);
        this.checkIfDeclaredExcReallyThrown = (Boolean)this.getInputParameter(PAR_CHECK_DECARED_EXC);
        this.checkTooGenericExceptions = (Boolean)this.getInputParameter(PAR_CHECK_TOO_GENERIC_EXC);
    }

    public void endVisit(ITypeDeclaration node) {
        this.inCatchBlockStack.pop();
    }

    public void endVisit(ICatchClause node) {
        this.inCatchBlockStack.pop();
        this.inCatchBlockStack.push(false);
    }
}

