/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.exception;

import com.sap.tc.jtools.jlint.jom.interfaces.ICatchClause;
import com.sap.tc.jtools.jlint.jom.interfaces.IClassInstanceCreation;
import com.sap.tc.jtools.jlint.jom.interfaces.IExpression;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IThrowStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.metrics.JomMetricVisitor;
import com.sap.tc.jtools.jlint.jom.metrics.MetricInfo;
import com.sap.tc.jtools.jlint.tests.exception.JomBindingUtil;
import java.util.ArrayList;

public class ExceptionHandlingMetric
extends JomMetricVisitor {
    private static final String NAME = "Exception Handling Metric";
    private static String TOTAL_NUMBER_OF_THROWABLE = "classes extending java.lang.Throwable";
    private static String TOTAL_NUMBER_OF_THROW_STATEMENTS = "throw statements";
    private static String TOTAL_NUMBER_OF_CATCH_BLOCKS = "catch blocks";
    private static String[] exceptionClasses = new String[]{"com.sap.exception.BaseException", "com.sap.exception.BaseRuntimeException", (class$java$sql$SQLException == null ? (class$java$sql$SQLException = ExceptionHandlingMetric.class$("java.sql.SQLException")) : class$java$sql$SQLException).getName(), (class$java$lang$RuntimeException == null ? (class$java$lang$RuntimeException = ExceptionHandlingMetric.class$("java.lang.RuntimeException")) : class$java$lang$RuntimeException).getName(), (class$java$lang$Exception == null ? (class$java$lang$Exception = ExceptionHandlingMetric.class$("java.lang.Exception")) : class$java$lang$Exception).getName(), (class$java$lang$Throwable == null ? (class$java$lang$Throwable = ExceptionHandlingMetric.class$("java.lang.Throwable")) : class$java$lang$Throwable).getName(), (class$java$lang$Error == null ? (class$java$lang$Error = ExceptionHandlingMetric.class$("java.lang.Error")) : class$java$lang$Error).getName()};
    private static String[] exceptionInterfaces = new String[]{"com.sap.exception.IBaseException"};
    static /* synthetic */ Class class$java$sql$SQLException;
    static /* synthetic */ Class class$java$lang$RuntimeException;
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$Error;

    public String getTestName() {
        return NAME;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean visit(IThrowStatement node) {
        IExpression expression = node.getExpression();
        IReferenceTypeBinding binding = null;
        if (expression instanceof IClassInstanceCreation) {
            IClassInstanceCreation classCreation = (IClassInstanceCreation)expression;
            ITypeBinding typeBinding = classCreation.getName().resolveTypeBinding();
            if (!(typeBinding instanceof IReferenceTypeBinding)) return true;
            binding = (IReferenceTypeBinding)typeBinding;
        } else {
            binding = (IReferenceTypeBinding)expression.resolveTypeBinding();
        }
        this.addMetricValue(TOTAL_NUMBER_OF_THROW_STATEMENTS, 1.0f, (Position)node);
        String bindingName = binding.getName();
        boolean foundClass = false;
        int i = 0;
        while (i < exceptionClasses.length) {
            if (bindingName.equals(exceptionClasses[i])) {
                this.addThrowMetricValue(exceptionClasses[i], true, 1.0f, (Position)node);
                return true;
            }
            ++i;
        }
        if (foundClass) return true;
        int i2 = 0;
        while (i2 < exceptionClasses.length) {
            if (JomBindingUtil.checkExtendsClassIndirectly(binding, exceptionClasses[i2])) {
                this.addThrowMetricValue(exceptionClasses[i2], false, 1.0f, (Position)node);
                return true;
            }
            ++i2;
        }
        return true;
    }

    public boolean visit(ICatchClause node) {
        String exceptionTypeName = node.getException().resolveBinding().getType().getName();
        this.addMetricValue(TOTAL_NUMBER_OF_CATCH_BLOCKS, 1.0f, (Position)node);
        int i = 0;
        while (i < exceptionClasses.length) {
            if (exceptionTypeName.equals(exceptionClasses[i])) {
                this.addMetricValue("caught exceptions of type " + exceptionClasses[i], 1.0f, (Position)node);
                break;
            }
            ++i;
        }
        return true;
    }

    public boolean visit(ITypeDeclaration node) {
        IReferenceTypeBinding binding = node.resolveBinding();
        IReferenceTypeBinding superClass = binding.getSuperclass();
        IReferenceTypeBinding[] interfaces = binding.getInterfaces();
        if (JomBindingUtil.checkExtendsClass((ITypeBinding)binding, (class$java$lang$Throwable == null ? (class$java$lang$Throwable = ExceptionHandlingMetric.class$("java.lang.Throwable")) : class$java$lang$Throwable).getName())) {
            this.addMetricValue(TOTAL_NUMBER_OF_THROWABLE, 1.0f, (Position)node);
        }
        if (superClass != null) {
            String superClassName = superClass.getName();
            boolean foundDirectSuperClass = false;
            int i = 0;
            while (i < exceptionClasses.length) {
                if (superClassName.equals(exceptionClasses[i])) {
                    this.addExtendsMetricValue(exceptionClasses[i], true, 1.0f, (Position)node);
                    foundDirectSuperClass = true;
                    break;
                }
                ++i;
            }
            if (!foundDirectSuperClass) {
                int i2 = 0;
                while (i2 < exceptionClasses.length) {
                    if (JomBindingUtil.checkExtendsClassIndirectly(superClass, exceptionClasses[i2])) {
                        this.addExtendsMetricValue(exceptionClasses[i2], false, 1.0f, (Position)node);
                        break;
                    }
                    ++i2;
                }
            }
        }
        boolean foundDirectImplementingInterface = false;
        int i = 0;
        while (i < interfaces.length) {
            IReferenceTypeBinding _interface = interfaces[i];
            String interfaceName = _interface.getName();
            int j = 0;
            while (j < exceptionInterfaces.length) {
                if (interfaceName.equals(exceptionInterfaces[j])) {
                    this.addImplementsMetricValue(exceptionInterfaces[j], true, 1.0f, (Position)node);
                    foundDirectImplementingInterface = true;
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (!foundDirectImplementingInterface) {
            int i3 = 0;
            while (i3 < exceptionInterfaces.length) {
                if (JomBindingUtil.checkImplementsInterface(binding, exceptionInterfaces[i3])) {
                    this.addImplementsMetricValue(exceptionInterfaces[i3], false, 1.0f, (Position)node);
                    break;
                }
                ++i3;
            }
        }
        return true;
    }

    protected void addExtendsMetricValue(String exceptionClass, boolean direct, float value, Position pos) {
        if (direct) {
            this.addMetricValue("classes extending " + exceptionClass + " directly", value, pos);
        } else {
            this.addMetricValue("classes extending " + exceptionClass + " indirectly", value, pos);
        }
    }

    protected void addImplementsMetricValue(String interfaceClass, boolean direct, float value, Position pos) {
        if (direct) {
            this.addMetricValue("interfaces implementing " + interfaceClass + " directly", value, pos);
        } else {
            this.addMetricValue("interfaces implementing " + interfaceClass + " indirectly", value, pos);
        }
    }

    protected void addThrowMetricValue(String exceptionClass, boolean direct, float value, Position pos) {
        if (direct) {
            this.addMetricValue("throw-statements throwing an exception class which extends " + exceptionClass + " directly", value, pos);
        } else {
            this.addMetricValue("throw-statements throwing an exception class which extends " + exceptionClass + " indirectly", value, pos);
        }
    }

    protected MetricInfo[] getMetricInfos() {
        ArrayList<MetricInfo> metricInfo = new ArrayList<MetricInfo>(20);
        int i = 0;
        while (i < exceptionClasses.length) {
            metricInfo.add(new MetricInfo("classes extending " + exceptionClasses[i] + " directly", 1, 10));
            metricInfo.add(new MetricInfo("classes extending " + exceptionClasses[i] + " indirectly", 1, 10));
            ++i;
        }
        int i2 = 0;
        while (i2 < exceptionInterfaces.length) {
            metricInfo.add(new MetricInfo("interfaces implementing " + exceptionInterfaces[i2] + " directly", 1, 10));
            metricInfo.add(new MetricInfo("interfaces implementing " + exceptionInterfaces[i2] + " indirectly", 1, 10));
            ++i2;
        }
        int i3 = 0;
        while (i3 < exceptionClasses.length) {
            metricInfo.add(new MetricInfo("throw-statements throwing an exception class which extends " + exceptionClasses[i3] + " directly", 1, 10));
            metricInfo.add(new MetricInfo("throw-statements throwing an exception class which extends " + exceptionClasses[i3] + " indirectly", 1, 10));
            ++i3;
        }
        int i4 = 0;
        while (i4 < exceptionClasses.length) {
            metricInfo.add(new MetricInfo("caught exceptions of type " + exceptionClasses[i4], 1, 10));
            ++i4;
        }
        metricInfo.add(new MetricInfo(TOTAL_NUMBER_OF_THROWABLE, 1));
        metricInfo.add(new MetricInfo(TOTAL_NUMBER_OF_THROW_STATEMENTS, 1));
        metricInfo.add(new MetricInfo(TOTAL_NUMBER_OF_CATCH_BLOCKS, 1));
        return metricInfo.toArray(new MetricInfo[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

