/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.exception;

import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ICatchClause;
import com.sap.tc.jtools.jlint.jom.interfaces.IEmptyStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodInvocation;
import com.sap.tc.jtools.jlint.jom.interfaces.IReturnStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IStatement;
import com.sap.tc.jtools.jlint.jom.interfaces.IThrowStatement;
import com.sap.tc.jtools.jlint.tests.exception.CatchBlockLifecycle;
import com.sap.tc.jtools.jlint.tests.exception.ExceptionLifecycle;
import com.sap.tc.jtools.jlint.tests.exception.ExceptionLifecycleAnalyser;
import com.sap.tc.jtools.jlint.tests.exception.JomMethodUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CatchBlockLifecycleAnalyser {
    protected CatchBlockLifecycle catchBlockLifecycle;
    boolean onlyWrongHandlingMethods = false;
    boolean emptyCatchClause = false;
    boolean onlyReturnStatements = false;
    boolean onlyEmptyStatements = false;
    boolean handlingMethod = false;
    boolean validExceptionLifecycle = false;
    List incorrectThrowStatements;
    int throwStatementCount = 0;
    int returnStatementCount = 0;
    int emptyStatementCount = 0;
    private static String[][] wrongHandlingMethods = new String[][]{{"println", "java.io.PrintStream", ""}, {"printStackTrace", "java.lang.Throwable", ""}};
    private static String[][] insufficentHandlingMethods = new String[][]{{"errorT", "com.sap.tc.logging.Location"}, {"getMessage", "java.lang.Throwable"}, {"toString", "java.lang.Throwable"}};

    public CatchBlockLifecycleAnalyser(CatchBlockLifecycle catchBlockLifecycle) {
        this.catchBlockLifecycle = catchBlockLifecycle;
        this.incorrectThrowStatements = new ArrayList();
    }

    public void analyse() {
        if (this.catchBlockLifecycle == null) {
            throw new NullPointerException("Attribute catchBlockLifecyle is null");
        }
        ICatchClause catchClause = this.catchBlockLifecycle.getCatchClause();
        List statements = catchClause.getBody().statements();
        if (statements == null || statements.size() == 0) {
            this.emptyCatchClause = true;
            return;
        }
        this.countStatements();
        this.analyseSimpleHandlingMethods();
        this.analyseExceptionLifecycle();
    }

    protected void analyseSimpleHandlingMethods() {
        if (wrongHandlingMethods == null) {
            return;
        }
        int wrongMethodCallCount = 0;
        ICatchClause catchClause = this.catchBlockLifecycle.getCatchClause();
        List statements = catchClause.getBody().statements();
        Iterator statementIt = statements.iterator();
        int i = 0;
        while (i < wrongHandlingMethods.length) {
            CatchBlockLifecycleAnalyser.wrongHandlingMethods[i][2] = "0";
            IMethodInvocation calledMethod = JomMethodUtil.checkMethodInvocation(statements, wrongHandlingMethods[i][0], wrongHandlingMethods[i][1], false);
            if (calledMethod != null) {
                ++wrongMethodCallCount;
                CatchBlockLifecycleAnalyser.wrongHandlingMethods[i][2] = "1";
            }
            ++i;
        }
        if (this.returnStatementCount == statements.size()) {
            this.onlyReturnStatements = true;
        } else if (this.emptyStatementCount == statements.size()) {
            this.onlyEmptyStatements = true;
        } else if (wrongMethodCallCount == statements.size() - this.returnStatementCount) {
            this.onlyWrongHandlingMethods = true;
        }
    }

    protected void analyseExceptionLifecycle() {
        HashMap exceptionLifecycleMap = this.catchBlockLifecycle.getExceptionLifecycleMap();
        Set keys = exceptionLifecycleMap.keySet();
        Iterator keyIt = keys.iterator();
        int handlingMethodCount = 0;
        boolean argumentMethodCount = false;
        int throwExitPointCount = 0;
        int returnExitPointCount = 0;
        int expressionExitPointCount = 0;
        int wrappedCount = 0;
        while (keyIt.hasNext()) {
            IBinding key = (IBinding)keyIt.next();
            ExceptionLifecycle exceptionLifecycle = (ExceptionLifecycle)exceptionLifecycleMap.get(key);
            throwExitPointCount += exceptionLifecycle.getThrowExitPointCount();
            returnExitPointCount += exceptionLifecycle.getReturnExitPointCount();
            expressionExitPointCount += exceptionLifecycle.getExpressionExitPointCount();
            ExceptionLifecycleAnalyser analyser = new ExceptionLifecycleAnalyser(exceptionLifecycle, this.catchBlockLifecycle.catchClause.getException());
            analyser.analyse();
            if (analyser.hasHandlingMethod()) {
                ++handlingMethodCount;
                this.handlingMethod = true;
            }
            if (analyser.isWrapped()) {
                ++wrappedCount;
            }
            this.incorrectThrowStatements.addAll(analyser.getIncorrectThrowStatements());
        }
        if (handlingMethodCount > 0 || wrappedCount > 0) {
            this.validExceptionLifecycle = true;
        } else if (throwExitPointCount + expressionExitPointCount > 0) {
            this.validExceptionLifecycle = true;
        }
    }

    protected void countStatements() {
        ICatchClause catchClause = this.catchBlockLifecycle.getCatchClause();
        List statements = catchClause.getBody().statements();
        Iterator statementIt = statements.iterator();
        while (statementIt.hasNext()) {
            IStatement statement = (IStatement)statementIt.next();
            if (statement instanceof IReturnStatement) {
                ++this.returnStatementCount;
                continue;
            }
            if (statement instanceof IEmptyStatement) {
                ++this.emptyStatementCount;
                continue;
            }
            if (!(statement instanceof IThrowStatement)) continue;
            ++this.throwStatementCount;
        }
        if (this.returnStatementCount == statements.size()) {
            this.onlyReturnStatements = true;
        } else if (this.emptyStatementCount == statements.size()) {
            this.onlyEmptyStatements = true;
        }
    }

    public List getIncorrectThrowStatements() {
        return this.incorrectThrowStatements;
    }

    public boolean hasOnlyWrongHandlingMethods() {
        return this.onlyWrongHandlingMethods;
    }

    public boolean hasEmptyCatchClause() {
        return this.emptyCatchClause;
    }

    public boolean hasThrowStatements() {
        return this.throwStatementCount > 0;
    }

    public boolean hasOnlyReturnStatements() {
        return this.onlyReturnStatements;
    }

    public boolean hasOnlyEmptyStatements() {
        return this.onlyEmptyStatements;
    }

    public boolean hasHandlingMethod() {
        return this.handlingMethod;
    }

    public boolean hasValidExceptionLifecycle() {
        return this.validExceptionLifecycle;
    }

    public String[][] getWrongHandlingMethods() {
        return wrongHandlingMethods;
    }
}

