/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.tests.ejb;

import com.sap.tc.jtools.jlint.jom.JomTestVisitor;
import com.sap.tc.jtools.jlint.jom.interfaces.IArrayTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IMethodDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IType;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.IVariableDeclaration;
import com.sap.tc.jtools.jlint.jom.interfaces.Position;
import com.sap.tc.jtools.jlint.jom.util.InheritanceTool;
import java.util.Iterator;
import java.util.List;

public class RemoteInterfaceTest
extends JomTestVisitor {
    private static final String NAME = "EJB serializable parameters";
    private static final String EJB_OBJECT_NAME = "javax.ejb.EJBObject";
    private static final String SERIALIZABLE_NAME = "java.io.Serializable";
    private static final String MSG_KEY_1 = "ejbremote.1";

    public String getTestName() {
        return NAME;
    }

    public boolean visit(ITypeDeclaration node) {
        IReferenceTypeBinding bnd = node.resolveBinding();
        if (bnd == null || !bnd.isInterface()) {
            return false;
        }
        return InheritanceTool.bndImplements((IReferenceTypeBinding)bnd, (String)EJB_OBJECT_NAME);
    }

    public boolean visit(IMethodDeclaration node) {
        IType returnType;
        ITypeBinding bnd;
        List params = node.parameters();
        if (params != null) {
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                IVariableDeclaration var = (IVariableDeclaration)iter.next();
                ITypeBinding varBnd = var.resolveBinding().getType();
                this.checkIfSerializable(varBnd, (Position)var);
            }
        }
        if ((bnd = (returnType = node.getReturnType()).resolveBinding()) != null) {
            this.checkIfSerializable(bnd, (Position)returnType);
        }
        return true;
    }

    private void checkIfSerializable(ITypeBinding bnd, Position pos) {
        if (bnd.isPrimitive()) {
            return;
        }
        if (bnd.isArray() && (bnd = ((IArrayTypeBinding)bnd).getElementType()).isPrimitive()) {
            return;
        }
        if (!InheritanceTool.bndImplements((IReferenceTypeBinding)((IReferenceTypeBinding)bnd), (String)SERIALIZABLE_NAME)) {
            this.addError(MSG_KEY_1, null, pos);
        }
    }
}

